/*
 * Copyright (c) 1999 Greg Haerr <greg@censoft.com>
 *
 * 8bpp (256 color) standard palette definition
 */
#include "device.h"

/*
 * Special palette for supporting 48 Windows colors and a 216 color
 * uniform color distribution.
 * Note: the first 20 colors are used internally as system colors.
 */
MWPALENTRY mwstdpal8[256] = {
	ARGBDEF( 255, 0  , 0  , 0   ),	/*   0 black*/
	ARGBDEF( 255, 255, 0  , 0   ),	/*   1 red*/
	ARGBDEF( 255, 0  , 255, 0   ),	/*   2 green*/
	ARGBDEF( 255, 255, 255, 0   ),	/*   3 yellow*/ /* COLOR_BACKGROUND*/
	ARGBDEF( 255, 0  , 0  , 255 ),	/*   4 blue*/  /* COLOR_ACTIVECAPTION A*/
	ARGBDEF( 255, 255, 0  , 255 ),	/*   5 magenta*/ /* COLOR_ACTIVECAPTION B*/
	ARGBDEF( 255, 0  , 255, 255 ),	/*   6 cyan*/
	ARGBDEF( 255, 255, 255, 255 ),	/*   7 white*/
	ARGBDEF( 0  , 0  , 0  , 0   ),	/*   8 tranparent*/
	ARGBDEF( 255, 170, 0  , 0   ),	/*   9 light red*/
	ARGBDEF( 255, 0  , 170, 0   ),	/*  10 light green*/
	ARGBDEF( 255, 170, 170, 0   ),	/*  11 light yellow*/
	ARGBDEF( 255, 0  , 0  , 170 ),	/*  12 light blue*/
	ARGBDEF( 255, 170, 0  , 170 ),	/*  13 light magenta*/
	ARGBDEF( 255, 0  , 170, 170 ),	/*  14 light cyan*/
	ARGBDEF( 255, 170, 170, 170 ),	/*  15 light white*/
	ARGBDEF( 255, 0  , 0  , 85  ),	/*  16 */
	ARGBDEF( 255, 0  , 85 , 0   ),	/*  17 */
	ARGBDEF( 255, 0  , 85 , 85  ),	/*  18 */
	ARGBDEF( 255, 0  , 85 , 170 ), 	/*  19 */
	ARGBDEF( 255, 0  , 85 , 255 ),	/*  20 */
	ARGBDEF( 255, 0  , 170, 85  ),	/*  21 */
	ARGBDEF( 255, 0  , 170, 255 ),	/*  22 */
	ARGBDEF( 255, 0  , 255, 85  ),	/*  23 */
	ARGBDEF( 255, 0  , 255, 170 ),	/*  24 */
	ARGBDEF( 255, 85 , 0  , 0   ),	/*  25 */
	ARGBDEF( 255, 85 , 0  , 85  ),	/*  26 */
	ARGBDEF( 255, 85 , 0  , 170 ),	/*  27 */
	ARGBDEF( 255, 85 , 0  , 255 ),	/*  28 */
	ARGBDEF( 255, 85 , 85 , 0   ),	/*  29 */
	ARGBDEF( 255, 85 , 85 , 85  ),	/*  30 */
	ARGBDEF( 255, 85 , 85 , 170 ),	/*  31 */
	ARGBDEF( 255, 85 , 85 , 255 ),	/*  32 */
	ARGBDEF( 255, 85 , 170, 0   ),	/*  33 */
	ARGBDEF( 255, 85 , 170, 85  ),	/*  34 */
	ARGBDEF( 255, 85 , 170, 170 ),	/*  35 */
	ARGBDEF( 255, 85 , 170, 255 ),	/*  36 */
	ARGBDEF( 255, 85 , 255, 0   ),	/*  37 */
	ARGBDEF( 255, 85 , 255, 85  ),	/*  38 */
	ARGBDEF( 255, 85 , 255, 170 ),	/*  39 */
	ARGBDEF( 255, 85 , 255, 255 ),	/*  40 */
	ARGBDEF( 255, 170, 0  , 85  ),	/*  41 */
	ARGBDEF( 255, 170, 0  , 255 ),	/*  42 */
	ARGBDEF( 255, 170, 85 , 0   ),	/*  43 */
	ARGBDEF( 255, 170, 85 , 85  ),	/*  44 */
	ARGBDEF( 255, 170, 85 , 170 ),	/*  45 */
	ARGBDEF( 255, 170, 85 , 255 ),	/*  46 */
	ARGBDEF( 255, 170, 170, 85  ),	/*  47 */
	ARGBDEF( 255, 170, 170, 255 ),	/*  48 */
	ARGBDEF( 255, 170, 255, 0   ),	/*  49 */
	ARGBDEF( 255, 170, 255, 85  ),	/*  50 */
	ARGBDEF( 255, 170, 255, 170 ),	/*  51 */
	ARGBDEF( 255, 170, 255, 255 ),	/*  52 */
	ARGBDEF( 255, 255, 0  , 85  ),	/*  53 */
	ARGBDEF( 255, 255, 0  , 170 ),	/*  54 */
	ARGBDEF( 255, 255, 85 , 0   ),	/*  55 */
	ARGBDEF( 255, 255, 85 , 85  ),	/*  56 */
	ARGBDEF( 255, 255, 85 , 170 ),	/*  57 */
	ARGBDEF( 255, 255, 85 , 255 ),	/*  58 */
	ARGBDEF( 255, 255, 170, 0   ),	/*  59 */
	ARGBDEF( 255, 255, 170, 85  ),	/*  60 */
	ARGBDEF( 255, 255, 170, 170 ),	/*  61 */
	ARGBDEF( 255, 255, 170, 255 ),	/*  62 */
	ARGBDEF( 255, 255, 255, 85  ),	/*  63 */
	ARGBDEF( 255, 255, 255, 170 ),	/*  64 */

/* alpha-plane is 128 */
	ARGBDEF( 128, 0  , 0  , 0   ),	/*  65 black*/
	ARGBDEF( 128, 255, 0  , 0   ),	/*  66 red*/
	ARGBDEF( 128, 0  , 255, 0   ),	/*  67 green*/
	ARGBDEF( 128, 255, 255, 0   ),	/*  68 yellow*/
	ARGBDEF( 128, 0  , 0  , 255 ),	/*  69 blue*/
	ARGBDEF( 128, 255, 0  , 255 ),	/*  70 magenta*/
	ARGBDEF( 128, 0  , 255, 255 ),	/*  71 cyan*/
	ARGBDEF( 128, 255, 255, 255 ),	/*  72 white*/
	ARGBDEF( 128, 170, 0  , 0   ),	/*  73 light red*/
	ARGBDEF( 128, 0  , 170, 0   ),	/*  74 light green*/
	ARGBDEF( 128, 170, 170, 0   ),	/*  75 light yellow*/
	ARGBDEF( 128, 0  , 0  , 170 ),	/*  76 light blue*/
	ARGBDEF( 128, 170, 0  , 170 ),	/*  77 light magenta*/
	ARGBDEF( 128, 0  , 170, 170 ),	/*  78 light cyan*/
	ARGBDEF( 128, 170, 170, 170 ),	/*  79 light white*/
	ARGBDEF( 128, 0  , 0  , 85  ),	/*  80 */
	ARGBDEF( 128, 0  , 85 , 0   ),	/*  81 */
	ARGBDEF( 128, 0  , 85 , 85  ),	/*  82 */
	ARGBDEF( 128, 0  , 85 , 170 ), 	/*  83 */
	ARGBDEF( 128, 0  , 85 , 255 ),	/*  84 */
	ARGBDEF( 128, 0  , 170, 85  ),	/*  85 */
	ARGBDEF( 128, 0  , 170, 255 ),	/*  86 */
	ARGBDEF( 128, 0  , 255, 85  ),	/*  87 */
	ARGBDEF( 128, 0  , 255, 170 ),	/*  88 */
	ARGBDEF( 128, 85 , 0  , 0   ),	/*  89 */
	ARGBDEF( 128, 85 , 0  , 85  ),	/*  90 */
	ARGBDEF( 128, 85 , 0  , 170 ),	/*  91 */
	ARGBDEF( 128, 85 , 0  , 255 ),	/*  92 */
	ARGBDEF( 128, 85 , 85 , 0   ),	/*  93 */
	ARGBDEF( 128, 85 , 85 , 85  ),	/*  94 */
	ARGBDEF( 128, 85 , 85 , 170 ),	/*  95 */
	ARGBDEF( 128, 85 , 85 , 255 ),	/*  96 */
	ARGBDEF( 128, 85 , 170, 0   ),	/*  97 */
	ARGBDEF( 128, 85 , 170, 85  ),	/*  98 */
	ARGBDEF( 128, 85 , 170, 170 ),	/*  99 */
	ARGBDEF( 128, 85 , 170, 255 ),	/* 100 */
	ARGBDEF( 128, 85 , 255, 0   ),	/* 101 */
	ARGBDEF( 128, 85 , 255, 85  ),	/* 102 */
	ARGBDEF( 128, 85 , 255, 170 ),	/* 103 */
	ARGBDEF( 128, 85 , 255, 255 ),	/* 104 */
	ARGBDEF( 128, 170, 0  , 85  ),	/* 105 */
	ARGBDEF( 128, 170, 0  , 255 ),	/* 106 */
	ARGBDEF( 128, 170, 85 , 0   ),	/* 107 */
	ARGBDEF( 128, 170, 85 , 85  ),	/* 108 */
	ARGBDEF( 128, 170, 85 , 170 ),	/* 109 */
	ARGBDEF( 128, 170, 85 , 255 ),	/* 110 */
	ARGBDEF( 128, 170, 170, 85  ),	/* 111 */
	ARGBDEF( 128, 170, 170, 255 ),	/* 112 */
	ARGBDEF( 128, 170, 255, 0   ),	/* 113 */
	ARGBDEF( 128, 170, 255, 85  ),	/* 114 */
	ARGBDEF( 128, 170, 255, 170 ),	/* 115 */
	ARGBDEF( 128, 170, 255, 255 ),	/* 116 */
	ARGBDEF( 128, 255, 0  , 85  ),	/* 117 */
	ARGBDEF( 128, 255, 0  , 170 ),	/* 118 */
	ARGBDEF( 128, 255, 85 , 0   ),	/* 119 */
	ARGBDEF( 128, 255, 85 , 85  ),	/* 120 */
	ARGBDEF( 128, 255, 85 , 170 ),	/* 121 */
	ARGBDEF( 128, 255, 85 , 255 ),	/* 122 */
	ARGBDEF( 128, 255, 170, 0   ),	/* 123 */
	ARGBDEF( 128, 255, 170, 85  ),	/* 124 */
	ARGBDEF( 128, 255, 170, 170 ),	/* 125 */
	ARGBDEF( 128, 255, 170, 255 ),	/* 126 */
	ARGBDEF( 128, 255, 255, 85  ),	/* 127 */

	RGBDEF( 0x66, 0x66, 0x00 ),	/* 128 */
	RGBDEF( 0x66, 0x66, 0x33 ),	/* 129 */
	RGBDEF( 0x66, 0x66, 0x66 ),	/* 130 */
	RGBDEF( 0x66, 0x66, 0x99 ),	/* 131 */
	RGBDEF( 0x66, 0x66, 0xcc ),	/* 132 */
	RGBDEF( 0x66, 0x66, 0xff ),	/* 133 */
	RGBDEF( 0x99, 0x66, 0x00 ),	/* 134 */
	RGBDEF( 0x99, 0x66, 0x33 ),	/* 135 */
	RGBDEF( 0x99, 0x66, 0x66 ),	/* 136 */
	RGBDEF( 0x99, 0x66, 0x99 ),	/* 137 */
	RGBDEF( 0x99, 0x66, 0xcc ),	/* 138 */
	RGBDEF( 0x99, 0x66, 0xff ),	/* 139 */
	RGBDEF( 0xcc, 0x66, 0x00 ),	/* 140 */
	RGBDEF( 0xcc, 0x66, 0x33 ),	/* 141 */
	RGBDEF( 0xcc, 0x66, 0x66 ),	/* 142 */
	RGBDEF( 0xcc, 0x66, 0x99 ),	/* 143 */
	RGBDEF( 0xcc, 0x66, 0xcc ),	/* 144 */
	RGBDEF( 0xcc, 0x66, 0xff ),	/* 145 */
	RGBDEF( 0xff, 0x66, 0x00 ),	/* 146 */
	RGBDEF( 0xff, 0x66, 0x33 ),	/* 147 */
	RGBDEF( 0xff, 0x66, 0x66 ),	/* 148 */
	RGBDEF( 0xff, 0x66, 0x99 ),	/* 149 */
	RGBDEF( 0xff, 0x66, 0xcc ),	/* 150 */
	RGBDEF( 0xff, 0x66, 0xff ),	/* 151 */
	RGBDEF( 0x00, 0x99, 0x00 ),	/* 152 */
	RGBDEF( 0x00, 0x99, 0x33 ),	/* 153 */
	RGBDEF( 0x00, 0x99, 0x66 ),	/* 154 */
	RGBDEF( 0x00, 0x99, 0x99 ),	/* 155 */
	RGBDEF( 0x00, 0x99, 0xcc ),	/* 156 */
	RGBDEF( 0x00, 0x99, 0xff ),	/* 157 */
	RGBDEF( 0x33, 0x99, 0x00 ),	/* 158 */
	RGBDEF( 0x33, 0x99, 0x33 ),	/* 159 */
	RGBDEF( 0x33, 0x99, 0x66 ),	/* 160 */
	RGBDEF( 0x33, 0x99, 0x99 ),	/* 161 */
	RGBDEF( 0x33, 0x99, 0xcc ),	/* 162 */
	RGBDEF( 0x33, 0x99, 0xff ),	/* 163 */
	RGBDEF( 0x66, 0x99, 0x00 ),	/* 164 */
	RGBDEF( 0x66, 0x99, 0x33 ),	/* 165 */
	RGBDEF( 0x66, 0x99, 0x66 ),	/* 166 */
	RGBDEF( 0x66, 0x99, 0x99 ),	/* 167 */
	RGBDEF( 0x66, 0x99, 0xcc ),	/* 168 */
	RGBDEF( 0x66, 0x99, 0xff ),	/* 169 */
	RGBDEF( 0x99, 0x99, 0x00 ),	/* 170 */
	RGBDEF( 0x99, 0x99, 0x33 ),	/* 171 */
	RGBDEF( 0x99, 0x99, 0x66 ),	/* 172 */
	RGBDEF( 0x99, 0x99, 0x99 ),	/* 173 */
	RGBDEF( 0x99, 0x99, 0xcc ),	/* 174 */
	RGBDEF( 0x99, 0x99, 0xff ),	/* 175 */
	RGBDEF( 0xcc, 0x99, 0x00 ),	/* 176 */
	RGBDEF( 0xcc, 0x99, 0x33 ),	/* 177 */
	RGBDEF( 0xcc, 0x99, 0x66 ),	/* 178 */
	RGBDEF( 0xcc, 0x99, 0x99 ),	/* 179 */
	RGBDEF( 0xcc, 0x99, 0xcc ),	/* 180 */
	RGBDEF( 0xcc, 0x99, 0xff ),	/* 181 */
	RGBDEF( 0xff, 0x99, 0x00 ),	/* 182 */
	RGBDEF( 0xff, 0x99, 0x33 ),	/* 183 */
	RGBDEF( 0xff, 0x99, 0x66 ),	/* 184 */
	RGBDEF( 0xff, 0x99, 0x99 ),	/* 185 */
	RGBDEF( 0xff, 0x99, 0xcc ),	/* 186 */
	RGBDEF( 0xff, 0x99, 0xff ),	/* 187 */
	RGBDEF( 0x00, 0xcc, 0x00 ),	/* 188 */
	RGBDEF( 0x00, 0xcc, 0x33 ),	/* 189 */
	RGBDEF( 0x00, 0xcc, 0x66 ),	/* 190 */
	RGBDEF( 0x00, 0xcc, 0x99 ),	/* 191 */
	RGBDEF( 0x00, 0xcc, 0xcc ),	/* 192 */
	RGBDEF( 0x00, 0xcc, 0xff ),	/* 193 */
	RGBDEF( 0x33, 0xcc, 0x00 ),	/* 194 */
	RGBDEF( 0x33, 0xcc, 0x33 ),	/* 195 */
	RGBDEF( 0x33, 0xcc, 0x66 ),	/* 196 */
	RGBDEF( 0x33, 0xcc, 0x99 ),	/* 197 */
	RGBDEF( 0x33, 0xcc, 0xcc ),	/* 198 */
	RGBDEF( 0x33, 0xcc, 0xff ),	/* 199 */
	RGBDEF( 0x66, 0xcc, 0x00 ),	/* 200 */
	RGBDEF( 0x66, 0xcc, 0x33 ),	/* 201 */
	RGBDEF( 0x66, 0xcc, 0x66 ),	/* 202 */
	RGBDEF( 0x66, 0xcc, 0x99 ),	/* 203 */
	RGBDEF( 0x66, 0xcc, 0xcc ),	/* 204 */
	RGBDEF( 0x66, 0xcc, 0xff ),	/* 205 */
	RGBDEF( 0x99, 0xcc, 0x00 ),	/* 206 */
	RGBDEF( 0x99, 0xcc, 0x33 ),	/* 207 */
	RGBDEF( 0x99, 0xcc, 0x66 ),	/* 208 */
	RGBDEF( 0x99, 0xcc, 0x99 ),	/* 209 */
	RGBDEF( 0x99, 0xcc, 0xcc ),	/* 210 */
	RGBDEF( 0x99, 0xcc, 0xff ),	/* 211 */
	RGBDEF( 0xcc, 0xcc, 0x00 ),	/* 212 */
	RGBDEF( 0xcc, 0xcc, 0x33 ),	/* 213 */
	RGBDEF( 0xcc, 0xcc, 0x66 ),	/* 214 */
	RGBDEF( 0xcc, 0xcc, 0x99 ),	/* 215 */
	RGBDEF( 0xcc, 0xcc, 0xcc ),	/* 216 */
	RGBDEF( 0xcc, 0xcc, 0xff ),	/* 217 */
	RGBDEF( 0xff, 0xcc, 0x00 ),	/* 218 */
	RGBDEF( 0xff, 0xcc, 0x33 ),	/* 219 */
	RGBDEF( 0xff, 0xcc, 0x66 ),	/* 220 */
	RGBDEF( 0xff, 0xcc, 0x99 ),	/* 221 */
	RGBDEF( 0xff, 0xcc, 0xcc ),	/* 222 */
	RGBDEF( 0xff, 0xcc, 0xff ),	/* 223 */
	RGBDEF( 0x00, 0xff, 0x33 ),	/* 224 */
	RGBDEF( 0x00, 0xff, 0x66 ),	/* 225 */
	RGBDEF( 0x00, 0xff, 0x99 ),	/* 226 */
	RGBDEF( 0x00, 0xff, 0xcc ),	/* 227 */
	RGBDEF( 0x33, 0xff, 0x00 ),	/* 228 */
	RGBDEF( 0x33, 0xff, 0x33 ),	/* 229 */
	RGBDEF( 0x33, 0xff, 0x66 ),	/* 230 */
	RGBDEF( 0x33, 0xff, 0x99 ),	/* 231 */
	RGBDEF( 0x33, 0xff, 0xcc ),	/* 232 */
	RGBDEF( 0x33, 0xff, 0xff ),	/* 233 */
	RGBDEF( 0x66, 0xff, 0x00 ),	/* 234 */
	RGBDEF( 0x66, 0xff, 0x33 ),	/* 235 */
	RGBDEF( 0x66, 0xff, 0x66 ),	/* 236 */
	RGBDEF( 0x66, 0xff, 0x99 ),	/* 237 */
	RGBDEF( 0x66, 0xff, 0xcc ),	/* 238 */
	RGBDEF( 0x66, 0xff, 0xff ),	/* 239 */
	RGBDEF( 0x99, 0xff, 0x00 ),	/* 240 */
	RGBDEF( 0x99, 0xff, 0x33 ),	/* 241 */
	RGBDEF( 0x99, 0xff, 0x66 ),	/* 242 */
	RGBDEF( 0x99, 0xff, 0x99 ),	/* 243 */
	RGBDEF( 0x99, 0xff, 0xcc ),	/* 244 */
	RGBDEF( 0x99, 0xff, 0xff ),	/* 245 */
	RGBDEF( 0xcc, 0xff, 0x00 ),	/* 246 */
	RGBDEF( 0xcc, 0xff, 0x33 ),	/* 247 */
	RGBDEF( 0xcc, 0xff, 0x66 ),	/* 248 */
	RGBDEF( 0xcc, 0xff, 0x99 ),	/* 249 */
	RGBDEF( 0xcc, 0xff, 0xcc ),	/* 250 */
	RGBDEF( 0xcc, 0xff, 0xff ),	/* 251 */
	RGBDEF( 0xff, 0xff, 0x33 ),	/* 252 */
	RGBDEF( 0xff, 0xff, 0x66 ),	/* 253 */
	RGBDEF( 0xff, 0xff, 0x99 ),	/* 254 */
	RGBDEF( 0xff, 0xff, 0xcc ),	/* 255 */
};

#if TEST
main()
{
	int	c;

	DPRINTF("%d\n", ((int)&stdpalette[1]) - (int)&stdpalette[0]);

	c = FindNearestColor(stdpalette, 224, 224, 224);
	DPRINTF("%d = %02x %02x %02x\n", c, stdpalette[c].r, stdpalette[c].g,
		stdpalette[c].b);
}
#endif
