/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/****************************************************************************/
#ifndef __FMB_DRV_H__
#define __FMB_DRV_H__

/********************************************************/
/*      Driver Constant definition       */
/********************************************************/

/* mamap area allocate param */
#define FMB_MMAP_BUFFER_SIZE (20 * 1024)  /**< mmap area : page buffer size  */

#ifndef H57_MP4_FUNCTION
#define FMB_MMAP_BUFFER_NUM  (3)      /**< mmap area : page buffer num   */
#endif /* H57_MP4_FUNCTION */


#ifdef MB86E61_FUNCTION
#define USB_VENDOR_ID_FUJITSU              0x004C5
#define USB_PRODUCT_ID_FUJITSU_MB86E61     0x02036
#endif /* MB86E61_FUNCTION */

/********************************************************/
/*      ioctl Constant definition       */
/********************************************************/

/* System command sync mode */
#define FMB_MODE_SYNC           0
#define FMB_MODE_ASYNC          1

/* Driver Internal mode */
#if 0 /* During a function add */
#define FMB_DATA_TYPE_ENCODE        0x00000001
#define FMB_DATA_TYPE_NOTIFY        0x00000002

#define FMB_DATA_ENCODE_TOP         0x00000000
#define FMB_DATA_ENCODE_BOTTOM      0x00000001

#define FMB_DATA_NOTIFY_NONE        0x00000000  /* (bit0000_0000) */
#define FMB_DATA_NOTIFY_ALL         0x0000000F  /* (bit0000_1111) */
#endif

#define FMB_VERSION_REG_SIZE            0x10
#define FMB_DRIVER_VERSION_LENGTH       0x14
#define FMB_SPIROM_VERSION_LENGTH       0x0A

#ifdef MB86E61_FUNCTION
/* boot event cancel type */
#define FMB_BOOT_EVENT_NO_CANCEL        0x0 /* default */
#define FMB_BOOT_EVENT_REMOVE_CANCEL    0x1
#define FMB_BOOT_EVENT_IOCTL_CANCEL     0x2
#endif /* MB86E61_FUNCTION */

/* eject event cancel type */
#define FMB_EJECT_EVENT_NO_CANCEL       0x0 /* default */
#define FMB_EJECT_EVENT_REMOVE_CANCEL   0x1
#define FMB_EJECT_EVENT_IOCTL_CANCEL    0x2

/* wait fact event type */
#define FMB_FACT_IRQ_NO_CANCEL          0x0 /* default */
#define FMB_FACT_IRQ_EVENT              0x1
#define FMB_FACT_IRQ_IOCTL_CANCEL       0x2
#define FMB_FACT_IRQ_REMOVE_CANCEL      0x3

/* wait bit event type */
#define FMB_WAIT_BIT_NO_CANCEL          0x0 /* default */
#define FMB_WAIT_BIT_EVENT              0x1
#define FMB_WAIT_BIT_IOCTL_CANCEL       0x2
#define FMB_WAIT_BIT_REMOVE_CANCEL      0x3

/* i2c access mode type */
#define FMB_I2C_RW_WITH_STOP            0x0
#define FMB_I2C_W_WITHOUT_STOP          0x1
#define FMB_I2C_R_REPEATED_START        0x1

#define FMB_I2C_BUF_SIZE                64
#define FMB_I2C_STATUS_SIZE              2
#define FMB_I2C_STOP_SIZE                1

/* define FACTOR Mask/Status bit infomation (struct fmb_fact_info:member en_mask/status )*/
/* API_IRQST */
#define FMB_FACT_STATE                 (0x00000004)   /* bit  2 */
#define FMB_FACT_CMD_ACK               (0x00000008)   /* bit  3 */
#define FMB_FACT_VSYNC                 (0x00000010)   /* bit  4 */
#define FMB_FACT_PCR_IN                (0x00000020)   /* bit  5 */
#define FMB_FACT_STREAM_BUFF           (0x00000040)   /* bit  6 */
#define FMB_FACT_PID_IN                (0x00000080)   /* bit  7 */
#define FMB_FACT_I2C                   (0x00000100)   /* bit  8 */
#define FMB_FACT_BCAS_STATE            (0x00000200)   /* bit  9 */
#define FMB_FACT_BCAS_DATA             (0x00000400)   /* bit 10 */
#define FMB_FACT_SECURE                (0x00000800)   /* bit 11 */

/* API_IRQST2 */
#define FMB_FACT_VFRAME2               (0x00020000)   /* bit 17(1) */
#define FMB_FACT_SYSTEM_INFO           (0x00040000)   /* bit 18(2) */
#define FMB_FACT_VFRAME_ERR            (0x00080000)   /* bit 19(3) */
#define FMB_FACT_VFRAME                (0x00100000)   /* bit 20(4) */
#define FMB_FACT_AFRAME                (0x00200000)   /* bit 21(5) */
#define FMB_FACT_STREAM_SIZE           (0x00400000)   /* bit 22(6) */
#define FMB_FACT_STREAM_SIZE2          (0x00800000)   /* bit 23(7) */
#define FMB_FACT_GOP_INFO              (0x01000000)   /* bit 24(8) */
#define FMB_FACT_GOP_INFO2             (0x02000000)   /* bit 25(9) */
#define FMB_FACT_XERROR                (0x80000000)   /* bit 31(15) */

#ifdef MB86E61_FUNCTION
#define FMB_SCMD_CTL_RETRY_NUM            5000
#define FMB_SCMD_CTL_DATA_SIZE            1024
#define FMB_SCMD_CTL_GET_SIZE             512
#define FMB_SCMD_CTL_GET_SIZE_USB         64

#define FMB_BULK_TYPE_IN                  0
#define FMB_BULK_TYPE_OUT                 1
#endif /* MB86E61_FUNCTION */

/********************************************************/
/*      ioctl Structure definition      */
/********************************************************/

struct fmb_param_info
{
    unsigned long   offset;     /**< register offset addres */
    unsigned short  bit_pos;    /**< bit position. This variable is invalid when make!=0 */
    unsigned short  bit_len;    /**< bit length.   This variable is invalid when make!=0 */
    unsigned short  mask;       /**< bit mask.     This variable is invalid when 0  */
    unsigned short  value;      /**< data of register mask=0:shift data mask!=0:not shift data*/
};

struct fmb_param_info32
{
    unsigned long   offset;     /**< register offset addres */
    unsigned short  bit_pos;    /**< bit position. This variable is invalid when make!=0 */
    unsigned short  bit_len;    /**< bit length.   This variable is invalid when make!=0 */
    unsigned long   mask;       /**< bit mask.     This variable is invalid when 0  */
    unsigned long   value;      /**< data of register mask=0:shift data mask!=0:not shift data*/
};

struct fmb_cmd_sys_info {
    unsigned short  id;
    unsigned short  sub_id;
    unsigned short  body;
    unsigned short  sync;
    void*       distinct;
};

#ifdef MB86E61_FUNCTION
struct fmb_cmd_ctl_info {
    unsigned long   cmd_size;
    unsigned char   cmd_data[FMB_SCMD_CTL_DATA_SIZE];
    unsigned long   get_offset;
    unsigned long   get_req_size;
    unsigned long   get_actual_size;
    unsigned char   get_data[FMB_SCMD_CTL_GET_SIZE];
    unsigned char   get_data_exist;
    unsigned char   error_code;
};

struct fmb_fifoclear_info {
    unsigned char   bulk_type;
    unsigned char   endpoint;
};
#endif /* MB86E61_FUNCTION */

struct fmb_cmd_ack_sys_info {
    unsigned short  id;
    unsigned short  sub_id;
    long        timeout;
    void*       distinct;
};

struct fmb_msg_sys_info {
    unsigned short  id;
    unsigned short  sub_id;
    unsigned short  body;
    long        timeout;
};

struct fmb_reg_info {
    unsigned long   reg_num;
    unsigned long   offset;
    unsigned short* prm_data;
};

struct fmb_version_info {
    char       driver_ver[FMB_DRIVER_VERSION_LENGTH];
    unsigned short firm_ver[FMB_VERSION_REG_SIZE/2];
    char       spirom_ver[FMB_SPIROM_VERSION_LENGTH];
};

struct fmb_get_msg_info {
    unsigned long   timeout;
};

struct fmb_usb_data_info {
    unsigned long   idVendor;
    unsigned long   idProduct;
    unsigned long   speed;
};

#if 0 /* During a function add */
struct fmb_param_info {
    unsigned long   prm_num;
    unsigned long*  prm_id;
    unsigned short* prm_data;
};
#endif
#if 0 /* During a function add */
struct fmb_internal_info {
    unsigned long   type;
    unsigned long   data;
};
#endif

struct fmb_read_i2c_info {
    unsigned char   adrs;
    unsigned char   buf[FMB_I2C_BUF_SIZE];
    unsigned short  length;
    unsigned char   acs_mode;
};

struct fmb_write_i2c_info {
    unsigned char   adrs;
    unsigned char   buf[FMB_I2C_BUF_SIZE];
    unsigned short  length;
    unsigned char   acs_mode;
};

struct fmb_stop_i2c_info {
    unsigned char   adrs;
};

struct fmb_get_i2c_status_info {
    unsigned char   adrs;
    unsigned char   buf[FMB_I2C_STATUS_SIZE];
};

struct fmb_fact_info
{
    unsigned long  en_mask;     /**< irq enable mask data 0:disable 1:disable */
    unsigned long  status;      /**< irq status data    [read]0:no event 1:event [write]0:none 1:event clear */
    unsigned char  *data;       /**< event reason data  When used for API of async info, this member is effective.  FMB_API_ASYNC_INFO only */
    size_t          size;       /**< event reason data area size */
    int             cret;       /**< wait cancel reason */
};

struct fmb_async_info
{
    unsigned long  en_mask;     /**< irq enable mask data 0:disable 1:disable */
    int            data_num;	/**< data area number   1:data1 2:data1 and data2 (for FMB_API_GET_ASYNC_INFO_SIZE)*/
    unsigned char *data1_addr;  /**< event reason data1 */
    size_t         data1_size;  /**< event reason data1 size */
    unsigned char *data2_addr;  /**< event reason data2 */
    size_t         data2_size;  /**< event reason data2 size */
};

struct fmb_read_thumbnail
{
    unsigned char *buffer;      /**< read buffer address */
    size_t  count;              /**< read data size */
    ssize_t actual_size;        /**< read data actual size */
};


/* write spi-rom status macro (struct fmb_write_spi_state_info member:state ) */
#define FMB_W_SPI_ST_WRITING   (0x00)
#define FMB_W_SPI_ST_COMPLETE  (0x01)
#define FMB_W_SPI_ST_FAILE     (0x80)
#define FMB_W_SPI_ST_SYS_ERR   (0xFF)

struct fmb_write_spi_state_info
{
    unsigned char  state;        /**< write spi state */
};

struct fmb_load_firm_info
{
    unsigned long  size;
    unsigned char *buffer;
};

#define FMB_DEVICE_INFO_STRING_SIZE (32)

struct fmb_device_info
{
    unsigned short idVendor;        /**< vendor id */
    unsigned short idProduct;       /**< product id */
    unsigned short speed;           /**< USB speed */
    unsigned char  manufacturer[FMB_DEVICE_INFO_STRING_SIZE]; /*< manufacturer string / no data [0]='\0' */
    unsigned char  product[FMB_DEVICE_INFO_STRING_SIZE];      /*< product      string / no data [0]='\0' */
    unsigned char  serial[FMB_DEVICE_INFO_STRING_SIZE];       /*< serial       string / no data [0]='\0' */
};

#define FMB_SPEC_IOMODE_IN  1   /**< usb control message ( apl <--data--- driver ) */
#define FMB_SPEC_IOMODE_OUT 2   /**< usb control message ( apl ---data--> driver ) */

struct fmb_spec_usb_setup_packet    /**< usb control message setup packet struct */
{
    union
    {
        struct {
            unsigned char bmRequestType;
            unsigned char bRequest;
#ifdef MULTIENDIAN_FUNCTION
            unsigned short   wValue;
            unsigned short   wIndex;
            unsigned short   wLength;
#else
            union {
                struct {
                    unsigned char    wValueL;
                    unsigned char    wValueH;
                };
                unsigned short   wValueLH;
            };
            union {
                struct {
                    unsigned char    wIndexL;
                    unsigned char    wIndexH;
                };
                unsigned short   wIndexLH;
            };
            union {
                struct {
                    unsigned char    wLengthL;
                    unsigned char    wLengthH;
                };
                unsigned short   wLengthLH;
            };
#endif
        };
        unsigned char setup_bin[8];
    };
};

struct fmb_spec_usb_control /**< usb control message struct */
{
    struct fmb_spec_usb_setup_packet    spacket;    /**< setup packet */
    int                                 endpoint;   /**< end point */
    int                                 io_mode;    /**< io mode FMB_SPEC_IOMODE_IN or FMB_SPEC_IOMODE_OUT */
    int                                 timeout;    /**< timeout [ usb_contrl_msg() ]*/
    int                                 result;     /**< result code [ usb_contrl_msg() ] */
    size_t                              data_size;  /**< data size */
    unsigned char                       *data;      /**< data area(need allocate user memory */
};

struct fmb_spec_wait_bit    /**< wait bit function struct */
{
    unsigned long   offset;         /**< wait bit offset */
    unsigned short  en_mask;        /**< wait bit enable mask data [bit data 0:none mask(watch bit) 1:mask] */
    unsigned short  status;         /**< wait bit status data   (expected value. The useful range is a part of .en_mask bit=0. ) */
    int             cret;           /**< wait bit cancel reason */
    unsigned long   interval_time;  /**< wait bit polling interval time(ms) need > 1000/HZ */
    unsigned long   num;            /**< wait bit watch out number 0:no watch out (other):watch out number(timeout = .interval_time * .num */
};


/** DEBUGON_USB_ACCESS ------- **/

#define FMB_USB_DEBUGMSG_ALL_ON     (0xFFFFFFFF)
#define FMB_USB_DEBUGMSG_ALL_OFF    (0x00000000)
#define FMB_USB_DEBUGMSG_CTL        (1)           /**< debug_msg out bit mask or bit flag position [USB Control   Message]*/
#define FMB_USB_DEBUGMSG_INT        (2)           /**< debug_msg out bit mask or bit flag position [USB Interrupt Message]*/
#define FMB_USB_DEBUGMSG_BULKIN     (4)           /**< debug_msg out bit mask or bit flag position [USB Bulk-IN   Message]*/
#define FMB_USB_DEBUGMSG_BULKOUT    (8)           /**< debug_msg out bit mask or bit flag position [USB Bulk-OUT  Message]*/
#define FMB_USB_DEBUGMSG_DEFAULT    ( FMB_USB_DEBUGMSG_CTL | FMB_USB_DEBUGMSG_INT | FMB_USB_DEBUGMSG_BULKIN | FMB_USB_DEBUGMSG_BULKOUT )

struct fmb_usb_debug_msg {
    unsigned long mask;      /**< debug_msg out bit mask 1:change bit 0: no change bit */
    unsigned long flag;      /**< debug_msg out bit flag 0:off 1:on ( bit flag is enable only when bit mask is enable.)*/
    int           cnt;       /**< Counter that outputs debugMessage in the previous state */ 
    unsigned long oldflag;   /**< (system reserved)debug_msg out oldflag */
};
/** ------- DEBUGON_USB_ACCESS **/

/********************************************************/
/*      ioctl Command definition        */
/********************************************************/

#define FMB_DEV_TYPE  0xAE

#define FMB_SET_READ_EPADDR           _IOW (FMB_DEV_TYPE, 0, int )
#define FMB_API_SEND_SYS_CMD          _IOWR(FMB_DEV_TYPE, 1, struct fmb_cmd_sys_info)
#define FMB_API_GET_LSI_REG           _IOR (FMB_DEV_TYPE, 2, struct fmb_reg_info)
#define FMB_API_SET_LSI_REG           _IOW (FMB_DEV_TYPE, 3, struct fmb_reg_info)
#define FMB_API_GET_VERSION           _IOR (FMB_DEV_TYPE, 4, struct fmb_version_info)
#define FMB_API_GET_MSG               _IOW (FMB_DEV_TYPE, 5, struct fmb_get_msg_info)
#define FMB_API_GET_EJECT_EVENT       _IO  (FMB_DEV_TYPE, 6)
#define FMB_API_CANCEL_EJECT_EVENT    _IO  (FMB_DEV_TYPE, 7)
#define FMB_API_GET_USB_INFO          _IOR (FMB_DEV_TYPE, 8, struct fmb_usb_data_info)
#define FMB_API_GET_PARAM             _IOR (FMB_DEV_TYPE, 9, struct fmb_param_info)
#define FMB_API_SET_PARAM             _IOWR(FMB_DEV_TYPE, 10, struct fmb_param_info)
#define FMB_API_READ_I2C_REG          _IOR (FMB_DEV_TYPE, 11, struct fmb_read_i2c_info)
#define FMB_API_WRITE_I2C_REG         _IOW (FMB_DEV_TYPE, 12, struct fmb_write_i2c_info)
#define FMB_API_STOP_I2C              _IOR (FMB_DEV_TYPE, 13, struct fmb_stop_i2c_info)
#define FMB_API_GET_I2C_STATUS        _IOR (FMB_DEV_TYPE, 14, struct fmb_get_i2c_status_info)
#define FMB_API_GET_PARAM32           _IOR (FMB_DEV_TYPE, 15, struct fmb_param_info32)
#define FMB_API_SET_PARAM32           _IOW (FMB_DEV_TYPE, 16, struct fmb_param_info32)
#define FMB_API_GET_FACTOR            _IOR (FMB_DEV_TYPE, 17, struct fmb_fact_info)
#define FMB_API_RESET_FACTOR          _IOW (FMB_DEV_TYPE, 18, struct fmb_fact_info)
#define FMB_API_GET_MASK_FACTOR       _IOR (FMB_DEV_TYPE, 19, struct fmb_fact_info)
#define FMB_API_SET_MASK_FACTOR       _IOW (FMB_DEV_TYPE, 20, struct fmb_fact_info)
#define FMB_API_WAIT_FACT             _IOWR(FMB_DEV_TYPE, 21, struct fmb_fact_info)
#define FMB_API_CANCEL_WAIT_FACT      _IO  (FMB_DEV_TYPE, 22)
#define FMB_API_GET_ASYNC_INFO        _IOWR(FMB_DEV_TYPE, 23, struct fmb_async_info)
#define FMB_API_GET_ASYNC_INFO_SIZE   _IOWR(FMB_DEV_TYPE, 24, struct fmb_async_info)
#define FMB_API_ASYNC_INFO            _IOWR(FMB_DEV_TYPE, 25, struct fmb_fact_info)
#define FMB_API_READ_THUMB            _IOWR(FMB_DEV_TYPE, 26, struct fmb_read_thumbnail)
#define FMB_API_GET_WRITE_SPI_STATE   _IOR (FMB_DEV_TYPE, 27, struct fmb_write_spi_state_info)
#define FMB_API_LOAD_FIRM             _IOW (FMB_DEV_TYPE, 28, struct fmb_load_firm_info)
#define FMB_API_GET_DEVICE_INFO       _IOR(FMB_DEV_TYPE, 31, struct fmb_device_info)
#ifdef MB86E61_FUNCTION
#define FMB_API_SEND_CTL_CMD           _IOWR(FMB_DEV_TYPE, 40, struct fmb_cmd_ctl_info)
#define FMB_API_GET_NOTIFY_FAILURE_MSG _IO  (FMB_DEV_TYPE, 41)
#define FMB_API_FIFO_CLEAR             _IOW (FMB_DEV_TYPE, 42, struct fmb_fifoclear_info)
#define FMB_API_CANCEL_NOTIFY_FAILURE_MSG _IO  (FMB_DEV_TYPE, 43)
#endif /* MB86E61_FUNCTION */

#define FMB_API_SPEC_USB_CONTROL      _IOWR(FMB_DEV_TYPE, 80, struct fmb_spec_usb_control)
#define FMB_API_SPEC_WAIT_BIT         _IOWR(FMB_DEV_TYPE, 81, struct fmb_spec_wait_bit)
#define FMB_API_SPEC_CANCEL_WAIT_BIT  _IO  (FMB_DEV_TYPE, 82)
/** DEBUGON_USB_ACCESS ------- **/
#define FMB_USB_SET_DEBUG_MSG         _IOWR(FMB_DEV_TYPE, 99, struct fmb_usb_debug_msg ) /**< control of debug message */
/** ------- DEBUGON_USB_ACCESS **/

#endif /* ifndef __FMB_DRV_H__ */
