/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/****************************************************************************/
#ifndef __FMB_SYS_ABS_H
#define __FMB_SYS_ABS_H

#include <linux/interrupt.h>

/* -- build option -- */
/* The option to be suitable for the platform is selected or the option is added. */
//#define FMB_SYS_ABS_TYPE_000 /* old version (fmb_driver ver. 0.0.4.0)*/
//#define FMB_SYS_ABS_TYPE_001 /* now defualt (fmb_driver ver. 0.0.4.1) To control the kernel message(info 120sec blocked ), wait_event() <etc.> were changed to wait_event_interruptible() <etc.>. */

#ifndef FMB_SYS_ABS_TYPE_000
#ifndef FMB_SYS_ABS_TYPE_001
 #define FMB_SYS_ABS_TYPE_001  /* set default */
#endif
#endif

/*------------------------------------------------------------------*/
/*  FMB_SYS_ABS_TYPE_000                                            */
/*------------------------------------------------------------------*/
#ifdef FMB_SYS_ABS_TYPE_000

#define FMB_SYS_ABS_wake_up( wq ) \
                              wake_up( wq )
#define FMB_SYS_ABS_wait_event( wq, condition ) ({ \
                              int _l_ret = 0; \
                              wait_event( wq, condition ); \
                              _l_ret; \
                              })
#define FMB_SYS_ABS_wait_event_timeout( wq, condition, time ) \
                              wait_event_timeout( wq, condition, time )

#define FMB_SYS_ABS_wake_up_interruptible( wq ) \
                              wake_up_interruptible( wq )
#define FMB_SYS_ABS_wait_event_interruptible_timeout( wq, condition, time ) \
                              wait_event_interruptible_timeout( wq, condition, time )

#endif /* FMB_SYS_ABS_TYPE_000 */


/*------------------------------------------------------------------*/
/*  FMB_SYS_ABS_TYPE_001                                            */
/*------------------------------------------------------------------*/
#ifdef FMB_SYS_ABS_TYPE_001

#define FMB_SYS_ABS_wake_up( wq ) \
                              wake_up_interruptible( wq )
#define FMB_SYS_ABS_wait_event( wq, condition ) \
                              wait_event_interruptible( wq, condition )
#define FMB_SYS_ABS_wait_event_timeout( wq, condition, time ) \
                              wait_event_interruptible_timeout( wq, condition, time )

#define FMB_SYS_ABS_wake_up_interruptible( wq ) \
                              wake_up_interruptible( wq )
#define FMB_SYS_ABS_wait_event_interruptible_timeout( wq, condition, time ) \
                              wait_event_interruptible_timeout( wq, condition, time )

#endif /* FMB_SYS_ABS_TYPE_001 */


/* The platform dependence part is adding described as follows. */
/*  .... */

#endif /* __FMB_SYS_ABS_H */

