/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/****************************************************************************/
#include "fmb_api.h"

#if 0 /* 1102 The support schedule when the future.  */
#define SIZEOF_ARRAY(array) (sizeof(array) / sizeof(array[0]))

/******************************************************************************
 Name       : Register table of MB86H57 additional parameter M
 Function   : To define the register address and field data for MB86H57
*******************************************************************************/
const struct fmb_param_table fmb_add_param_m[] = {
    { 0x000800c0, 0x00ff, 0x0008, 1 },      
    { 0x000800c0, 0x00ff, 0x0000, 1 },      
    { 0x000800c2, 0x0001, 0x000e, 1 },      
    { 0x000800c2, 0x0001, 0x000c, 1 },      
    { 0x000800c2, 0x0001, 0x000a, 1 },      
    { 0x000800c2, 0x0001, 0x0008, 1 },      
    { 0x000800c2, 0x000f, 0x0000, 1 },      
    { 0x000800c4, 0xffff, 0x0000, 1 },      
    { 0x000800c6, 0xffff, 0x0000, 1 },      
    { 0x000800c8, 0xffff, 0x0000, 1 },      
    { 0x000800ca, 0xffff, 0x0000, 1 },      
    { 0x000800cc, 0xffff, 0x0000, 1 },      
    { 0x000800ce, 0xffff, 0x0000, 1 },      
    { 0x000800d0, 0xffff, 0x0000, 1 },      
    { 0x000800d2, 0xffff, 0x0000, 1 },      
    { 0x000800e0, 0x1fff, 0x0000, 1 },      
    { 0x000800e2, 0x1fff, 0x0000, 1 },      
    { 0x000800e4, 0x1fff, 0x0000, 1 },      
    { 0x000800ea, 0x00ff, 0x0008, 1 },      
    { 0x000800ea, 0x00ff, 0x0000, 1 },      
    { 0x000800ec, 0x00ff, 0x0000, 1 },      
    { 0x000800ee, 0x00ff, 0x0000, 1 },      
    { 0x000800f0, 0xffff, 0x0000, 1 },      
    { 0x000800f2, 0xffff, 0x0000, 1 },      
    { 0x000800f4, 0xffff, 0x0000, 1 },      
    { 0x000800f6, 0xffff, 0x0000, 1 },      
    { 0x000800f8, 0xffff, 0x0000, 1 },      
    { 0x000800fa, 0xffff, 0x0000, 1 },      
    { 0x000800fc, 0xffff, 0x0000, 1 },      
    { 0x000800fe, 0xffff, 0x0000, 1 },      
    { 0x00080100, 0xffff, 0x0000, 1 },      
    { 0x00080102, 0xffff, 0x0000, 1 },      
    { 0x00080104, 0xffff, 0x0000, 1 },      
    { 0x00080106, 0xffff, 0x0000, 1 },      
    { 0x00080108, 0xffff, 0x0000, 1 },      
    { 0x0008010a, 0xffff, 0x0000, 1 },      
    { 0x0008010c, 0xffff, 0x0000, 1 },      
    { 0x0008010e, 0xffff, 0x0000, 1 },      
    { 0x00080110, 0xffff, 0x0000, 1 },      
    { 0x00080112, 0xffff, 0x0000, 1 },      
    { 0x00080114, 0xffff, 0x0000, 1 },      
    { 0x00080116, 0xffff, 0x0000, 1 },      
    { 0x00080118, 0xffff, 0x0000, 1 },      
    { 0x0008011a, 0xffff, 0x0000, 1 },      
    { 0x0008011c, 0xffff, 0x0000, 1 },      
    { 0x0008011e, 0xffff, 0x0000, 1 },      
    { 0x00080120, 0xffff, 0x0000, 1 },      
    { 0x00080122, 0xffff, 0x0000, 1 },      
    { 0x00080124, 0xffff, 0x0000, 1 },      
    { 0x00080126, 0xffff, 0x0000, 1 },      
    { 0x00080128, 0xffff, 0x0000, 1 },      
    { 0x0008012a, 0xffff, 0x0000, 1 },      
    { 0x0008012c, 0xffff, 0x0000, 1 },      
    { 0x0008012e, 0xffff, 0x0000, 1 },      
    { 0x00080130, 0xffff, 0x0000, 1 },      
    { 0x00080132, 0xffff, 0x0000, 1 },      
    { 0x00080134, 0xffff, 0x0000, 1 },      
    { 0x00080136, 0xffff, 0x0000, 1 },      
    { 0x00080138, 0xffff, 0x0000, 1 },      
    { 0x0008013a, 0xffff, 0x0000, 1 },      
    { 0x0008013c, 0xffff, 0x0000, 1 },      
    { 0x0008013e, 0xffff, 0x0000, 1 },      
    { 0x00080140, 0xffff, 0x0000, 1 },      
    { 0x00080142, 0xffff, 0x0000, 1 },      
    { 0x00080144, 0xffff, 0x0000, 1 },      
    { 0x00080146, 0xffff, 0x0000, 1 },      
    { 0x00080148, 0xffff, 0x0000, 1 },      
    { 0x0008014a, 0xffff, 0x0000, 1 },      
    { 0x0008014c, 0xffff, 0x0000, 1 },      
    { 0x0008014e, 0xffff, 0x0000, 1 },      
    { 0x00080150, 0xffff, 0x0000, 1 },      
    { 0x00080152, 0xffff, 0x0000, 1 },      
    { 0x00080154, 0xffff, 0x0000, 1 },      
    { 0x00080156, 0xffff, 0x0000, 1 },      
    { 0x00080158, 0xffff, 0x0000, 1 },      
    { 0x0008015a, 0xffff, 0x0000, 1 },      
    { 0x0008015c, 0xffff, 0x0000, 1 },      
    { 0x0008015e, 0xffff, 0x0000, 1 },      
    { 0x00080160, 0xffff, 0x0000, 1 },      
    { 0x00080162, 0xffff, 0x0000, 1 },      
    { 0x00080164, 0xffff, 0x0000, 1 },      
    { 0x00080166, 0xffff, 0x0000, 1 },      
    { 0x00080168, 0xffff, 0x0000, 1 },      
    { 0x0008016a, 0xffff, 0x0000, 1 },      
    { 0x0008016c, 0xffff, 0x0000, 1 },      
    { 0x0008016e, 0xffff, 0x0000, 1 },      
    { 0x00080170, 0xffff, 0x0000, 1 },      
    { 0x00080172, 0xffff, 0x0000, 1 },      
    { 0x00080174, 0xffff, 0x0000, 1 },      
    { 0x00080176, 0xffff, 0x0000, 1 },      
    { 0x00080178, 0xffff, 0x0000, 1 },      
    { 0x0008017a, 0xffff, 0x0000, 1 },      
    { 0x0008017c, 0xffff, 0x0000, 1 },      
    { 0x0008017e, 0xffff, 0x0000, 1 },      
    { 0x00080180, 0xffff, 0x0000, 1 },      
    { 0x00080182, 0xffff, 0x0000, 1 },      
    { 0x00080184, 0xffff, 0x0000, 1 },      
    { 0x00080186, 0xffff, 0x0000, 1 },      
    { 0x00080188, 0xffff, 0x0000, 1 },      
    { 0x0008018a, 0xffff, 0x0000, 1 },      
    { 0x0008018c, 0xffff, 0x0000, 1 },      
    { 0x0008018e, 0xffff, 0x0000, 1 },      
    { 0x00080190, 0xffff, 0x0000, 1 },      
    { 0x00080192, 0xffff, 0x0000, 1 },      
    { 0x00080194, 0xffff, 0x0000, 1 },      
    { 0x00080196, 0xffff, 0x0000, 1 },      
    { 0x00080198, 0xffff, 0x0000, 1 },      
    { 0x0008019a, 0xffff, 0x0000, 1 },      
    { 0x0008019c, 0xffff, 0x0000, 1 },      
    { 0x0008019e, 0xffff, 0x0000, 1 },      
    { 0x000801a0, 0xffff, 0x0000, 1 },      
    { 0x000801a2, 0xffff, 0x0000, 1 },      
    { 0x000801a4, 0x0001, 0x000f, 1 },      
    { 0x000801a4, 0x01ff, 0x0000, 1 },      
    { 0x000801b0, 0xffff, 0x0000, 1 },      
    { 0x000801b2, 0xffff, 0x0000, 1 },      
    { 0x000801b4, 0x000f, 0x000c, 1 },      
    { 0x000801b4, 0x000f, 0x0008, 1 },      
    { 0x000801b4, 0x000f, 0x0004, 1 },      
    { 0x000801b4, 0x000f, 0x0000, 1 },      
    { 0x000801c0, 0xffff, 0x0000, 1 },      
    { 0x000801c2, 0xffff, 0x0000, 1 },      
    { 0x000801c4, 0xffff, 0x0000, 1 },      
    { 0x000801c6, 0xffff, 0x0000, 1 },      
};

/******************************************************************************
 Name       : Register Table of MB86H57 additional parameter V
 Function   : To define the register address and field data for MB86H57
*******************************************************************************/
const struct fmb_param_table fmb_add_param_v[] = {
    { 0x000801e0, 0x0001, 0x000f, 1},       
    { 0x000801e0, 0x0001, 0x0000, 1},       
    { 0x000801e4, 0x0001, 0x0004, 1},       
    { 0x000801ee, 0xffff, 0x0000, 1},       
    { 0x000801f0, 0xffff, 0x0000, 1},       
    { 0x000801f2, 0xffff, 0x0000, 1},       
    { 0x000801f4, 0xffff, 0x0000, 1},       
    { 0x000801f6, 0xffff, 0x0000, 1},       
    { 0x000801f8, 0xffff, 0x0000, 1},       
    { 0x000801fa, 0xffff, 0x0000, 1},       
    { 0x000801fc, 0xffff, 0x0000, 1},       
    { 0x000801fe, 0xffff, 0x0000, 1},       
};

/******************************************************************************
 Name       : Register Table of MB86H57 additional parameter A
 Function   : To define the register address and field data for MB86H57
*******************************************************************************/
const struct fmb_param_table fmb_add_param_a[] = {
    { 0x00001c00, 0xffff, 0x0000, 1 },      
};

/******************************************************************************
 Name       : Register Table of MB86H57 initialization parameter M
 Function   : To define the register address and field data for MB86H57
*******************************************************************************/
const struct fmb_param_table fmb_init_param_m[] = {
    { 0x00001000, 0x0003, 0x0008, 1 },      
    { 0x00001000, 0x0003, 0x0000, 1 },      
    { 0x00001002, 0x0001, 0x000f, 1 },      
    { 0x00001002, 0x0001, 0x000a, 1 },      
    { 0x00001002, 0x0003, 0x0008, 1 },      
    { 0x00001002, 0x0001, 0x0007, 1 },      
    { 0x00001002, 0x007f, 0x0000, 1 },      
    { 0x00001004, 0x0001, 0x0008, 1 },      
    { 0x00001004, 0x0001, 0x0002, 1 },      
    { 0x00001004, 0x0003, 0x0000, 1 },      
    { 0x00001006, 0xffff, 0x0000, 1 },      
    { 0x00001008, 0x0003, 0x000c, 1 },      
    { 0x00001008, 0x0003, 0x0008, 1 },      
    { 0x00001008, 0x0003, 0x0004, 1 },      
    { 0x00001008, 0x0003, 0x0000, 1 },      
    { 0x0000100a, 0xffff, 0x0000, 1 },      
    { 0x0000100c, 0xffff, 0x0000, 1 },      
    { 0x0000100e, 0xffff, 0x0000, 1 },      
    { 0x00001010, 0x0001, 0x000f, 1 },      
    { 0x00001010, 0x01ff, 0x0000, 1 },      
    { 0x00001012, 0xffff, 0x0000, 1 },      
    { 0x00001014, 0xffff, 0x0000, 1 },      
    { 0x00001016, 0x1fff, 0x0000, 1 },      
    { 0x00001018, 0x1fff, 0x0000, 1 },      
    { 0x0000101a, 0x1fff, 0x0000, 1 },      
    { 0x0000101c, 0x1fff, 0x0000, 1 },      
    { 0x0000101e, 0x1fff, 0x0000, 1 },      
    { 0x00001020, 0x00ff, 0x0000, 1 },      
    { 0x00001022, 0x00ff, 0x0008, 1 },      
    { 0x00001022, 0x00ff, 0x0000, 1 },      
    { 0x00001024, 0x0001, 0x0000, 1 },      
    { 0x00001028, 0x001f, 0x0008, 1 },      
    { 0x00001028, 0x001f, 0x0000, 1 },      
    { 0x0000102A, 0x001f, 0x0000, 1 },      
    { 0x00001080, 0x00ff, 0x0000, 1 },      
    { 0x00001082, 0xffff, 0x0000, 1 },      
    { 0x00001084, 0xffff, 0x0000, 1 },      
    { 0x00001086, 0x0001, 0x000f, 1 },      
    { 0x00001086, 0x01ff, 0x0000, 1 },      
    { 0x00001088, 0xffff, 0x0000, 1 },      
    { 0x0000108a, 0xffff, 0x0000, 1 },      
    { 0x0000108c, 0x0001, 0x000f, 1 },      
    { 0x0000108c, 0x01ff, 0x0000, 1 },      
    { 0x00001100, 0xffff, 0x0000, 1 },      
    { 0x00001102, 0xffff, 0x0000, 1 },      
    { 0x00001104, 0x0001, 0x000f, 1 },      
    { 0x00001104, 0x0001, 0x0000, 1 },      
    { 0x00001106, 0x000f, 0x000c, 1 },      
    { 0x00001106, 0x000f, 0x0008, 1 },      
    { 0x00001106, 0x000f, 0x0004, 1 },      
    { 0x00001106, 0x000f, 0x0000, 1 },      
    { 0x00001110, 0x007f, 0x0000, 1 },      
    { 0x00001112, 0x007f, 0x0000, 1 },      
    { 0x00001114, 0x03ff, 0x0000, 1 },      
    { 0x00001116, 0x007f, 0x0000, 1 },      
    { 0x00001120, 0xffff, 0x0000, 1 },      
    { 0x00001122, 0xffff, 0x0000, 1 },      
    { 0x00001130, 0x0001, 0x0000, 1 },      
    { 0x00001142, 0x0001, 0x0000, 1 },      
    { 0x00001144, 0x0003, 0x000c, 1 },      
    { 0x00001144, 0x0003, 0x0008, 1 },      
    { 0x00001144, 0x0003, 0x0004, 1 },      
    { 0x00001144, 0x0003, 0x0000, 1 },      
    { 0x00001146, 0x0001, 0x0008, 1 },      
    { 0x00001146, 0x0003, 0x0004, 1 },      
    { 0x00001146, 0x0003, 0x0000, 1 },      
    { 0x00001148, 0x0001, 0x0008, 1 },      
    { 0x00001148, 0x0003, 0x0004, 1 },      
    { 0x00001148, 0x0001, 0x0001, 1 },      
    { 0x0000114a, 0x0001, 0x0000, 1 },      
    { 0x0000114c, 0xffff, 0x0000, 1 },      
    { 0x0000114e, 0xffff, 0x0000, 1 },      
    { 0x00001150, 0xffff, 0x0000, 1 },      
    { 0x00001152, 0xffff, 0x0000, 1 },      
};

/******************************************************************************
 Name       : Register Table of MB86H57 initialization parameter V
 Function   : To define the register address and field data for MB86H57
*******************************************************************************/
const struct fmb_param_table fmb_init_param_v[] = {
    { 0x00001404, 0x0001, 0x000d, 1 },      
    { 0x00001404, 0x0001, 0x000c, 1 },      
    { 0x00001404, 0x0001, 0x0009, 1 },      
    { 0x00001404, 0x0001, 0x0008, 1 },      
    { 0x00001404, 0x0001, 0x0007, 1 },      
    { 0x00001404, 0x0001, 0x0006, 1 },      
    { 0x00001404, 0x0001, 0x0005, 1 },      
    { 0x00001404, 0x0001, 0x0004, 1 },      
    { 0x00001404, 0x0001, 0x0003, 1 },      
    { 0x00001404, 0x0003, 0x0000, 1 },      
    { 0x00001406, 0xffff, 0x0000, 1 },      
    { 0x00001408, 0xffff, 0x0000, 1 },      
    { 0x0000140a, 0x0001, 0x000f, 1 },      
    { 0x0000140a, 0x0001, 0x000e, 1 },      
    { 0x0000140a, 0x0003, 0x000c, 1 },      
    { 0x0000140a, 0x0007, 0x0008, 1 },      
    { 0x0000140a, 0x00ff, 0x0000, 1 },      
    { 0x0000140c, 0x00ff, 0x0000, 1 },      
    { 0x0000140e, 0x0003, 0x000e, 1 },      
    { 0x0000140e, 0x0001, 0x000a, 1 },      
    { 0x0000140e, 0x0001, 0x0008, 1 },      
    { 0x0000140e, 0x0001, 0x0000, 1 },      
    { 0x00001410, 0x00ff, 0x0008, 1 },      
    { 0x00001410, 0x00ff, 0x0000, 1 },      
    { 0x00001412, 0x00ff, 0x0008, 1 },      
    { 0x00001412, 0x00ff, 0x0000, 1 },      
    { 0x00001416, 0x0001, 0x0000, 1 },      
    { 0x00001418, 0x0001, 0x0008, 1 },      
    { 0x00001418, 0x0001, 0x0000, 1 },      
    { 0x0000141c, 0xffff, 0x0000, 1 },      
    { 0x0000141e, 0xffff, 0x0000, 1 },      
    { 0x00001420, 0xffff, 0x0000, 1 },      
    { 0x00001422, 0xffff, 0x0000, 1 },      
    { 0x00001424, 0x0001, 0x0008, 1 },      
    { 0x00001424, 0x000f, 0x0000, 1 },      
    { 0x00001430, 0x00ff, 0x0008, 1 },      
    { 0x00001430, 0x00ff, 0x0000, 1 },      
    { 0x00001432, 0x000f, 0x0008, 1 },      
    { 0x00001432, 0x000f, 0x0000, 1 },      
    { 0x00001434, 0x00ff, 0x0000, 1 },      
    { 0x00001440, 0xffff, 0x0000, 1 },      
    { 0x00001442, 0xffff, 0x0000, 1 },      
    { 0x00001444, 0xffff, 0x0000, 1 },      
    { 0x00001446, 0xffff, 0x0000, 1 },      
    { 0x00001448, 0xffff, 0x0000, 1 },      
    { 0x0000144a, 0xffff, 0x0000, 1 },      
    { 0x0000144c, 0xffff, 0x0000, 1 },      
    { 0x0000144e, 0xffff, 0x0000, 1 },      
    { 0x00001450, 0xffff, 0x0000, 1 },      
    { 0x00001452, 0xffff, 0x0000, 1 },      
    { 0x00001454, 0xffff, 0x0000, 1 },      
    { 0x00001456, 0xffff, 0x0000, 1 },      
    { 0x00001458, 0xffff, 0x0000, 1 },      
    { 0x0000145a, 0xffff, 0x0000, 1 },      
    { 0x0000145c, 0xffff, 0x0000, 1 },      
    { 0x0000145e, 0x00ff, 0x0000, 1 },      
    { 0x00001460, 0x00ff, 0x0000, 1 },      
    { 0x00001462, 0x00ff, 0x0000, 1 },      
    { 0x00001464, 0x00ff, 0x0000, 1 },      
    { 0x00001466, 0x00ff, 0x0000, 1 },      
    { 0x00001468, 0x00ff, 0x0000, 1 },      
    { 0x0000146a, 0x00ff, 0x0000, 1 },      
    { 0x0000146c, 0x00ff, 0x0000, 1 },      
    { 0x0000146e, 0x00ff, 0x0000, 1 },      
    { 0x00001470, 0x00ff, 0x0000, 1 },      
    { 0x00001472, 0x00ff, 0x0000, 1 },      
    { 0x00001474, 0x00ff, 0x0000, 1 },      
    { 0x00001476, 0x00ff, 0x0000, 1 },      
    { 0x00001478, 0x00ff, 0x0000, 1 },      
    { 0x0000147a, 0x00ff, 0x0000, 1 },      
    { 0x0000147c, 0x00ff, 0x0000, 1 },      
    { 0x0000147e, 0x00ff, 0x0000, 1 },      
    { 0x00001480, 0xffff, 0x0000, 1 },      
    { 0x00001482, 0xffff, 0x0000, 1 },      
    { 0x00001484, 0xffff, 0x0000, 1 },      
    { 0x00001486, 0xffff, 0x0000, 1 },      
    { 0x00001488, 0xffff, 0x0000, 1 },      
    { 0x0000148a, 0xffff, 0x0000, 1 },      
    { 0x0000148c, 0xffff, 0x0000, 1 },      
    { 0x0000148e, 0xffff, 0x0000, 1 },      
    { 0x00001490, 0xffff, 0x0000, 1 },      
    { 0x00001492, 0xffff, 0x0000, 1 },      
    { 0x00001494, 0xffff, 0x0000, 1 },      
    { 0x00001496, 0xffff, 0x0000, 1 },      
    { 0x00001498, 0xffff, 0x0000, 1 },      
    { 0x0000149a, 0xffff, 0x0000, 1 },      
    { 0x0000149c, 0xffff, 0x0000, 1 },      
    { 0x0000149e, 0xffff, 0x0000, 1 },      
    { 0x000014a0, 0xffff, 0x0000, 1 },      
    { 0x000014a2, 0xffff, 0x0000, 1 },      
    { 0x000014a4, 0xffff, 0x0000, 1 },      
    { 0x000014a6, 0xffff, 0x0000, 1 },      
    { 0x000014a8, 0xffff, 0x0000, 1 },      
    { 0x000014aa, 0xffff, 0x0000, 1 },      
    { 0x000014ac, 0xffff, 0x0000, 1 },      
    { 0x000014ae, 0xffff, 0x0000, 1 },      
    { 0x000014b0, 0xffff, 0x0000, 1 },      
    { 0x000014b2, 0xffff, 0x0000, 1 },      
    { 0x000014b4, 0xffff, 0x0000, 1 },      
    { 0x000014b6, 0xffff, 0x0000, 1 },      
    { 0x000014b8, 0xffff, 0x0000, 1 },      
    { 0x000014ba, 0xffff, 0x0000, 1 },      
    { 0x000014bc, 0xffff, 0x0000, 1 },      
    { 0x000014be, 0xffff, 0x0000, 1 },      
    { 0x000014c0, 0xffff, 0x0000, 1 },      
    { 0x000014c2, 0xffff, 0x0000, 1 },      
    { 0x000014c4, 0xffff, 0x0000, 1 },      
    { 0x000014c6, 0xffff, 0x0000, 1 },      
    { 0x000014c8, 0xffff, 0x0000, 1 },      
    { 0x000014ca, 0xffff, 0x0000, 1 },      
    { 0x000014cc, 0xffff, 0x0000, 1 },      
    { 0x000014ce, 0xffff, 0x0000, 1 },      
    { 0x000014d0, 0xffff, 0x0000, 1 },      
    { 0x000014d2, 0xffff, 0x0000, 1 },      
    { 0x000014d4, 0xffff, 0x0000, 1 },      
    { 0x000014d6, 0xffff, 0x0000, 1 },      
    { 0x000014d8, 0xffff, 0x0000, 1 },      
    { 0x000014da, 0xffff, 0x0000, 1 },      
    { 0x000014dc, 0xffff, 0x0000, 1 },      
    { 0x000014de, 0xffff, 0x0000, 1 },      
    { 0x000014e0, 0xffff, 0x0000, 1 },      
    { 0x000014e2, 0xffff, 0x0000, 1 },      
    { 0x000014e4, 0xffff, 0x0000, 1 },      
    { 0x000014e6, 0xffff, 0x0000, 1 },      
    { 0x000014e8, 0xffff, 0x0000, 1 },      
    { 0x000014ea, 0xffff, 0x0000, 1 },      
    { 0x000014ec, 0xffff, 0x0000, 1 },      
    { 0x000014ee, 0xffff, 0x0000, 1 },      
    { 0x000014f0, 0xffff, 0x0000, 1 },      
    { 0x000014f2, 0xffff, 0x0000, 1 },      
    { 0x000014f4, 0xffff, 0x0000, 1 },      
    { 0x000014f6, 0xffff, 0x0000, 1 },      
    { 0x000014f8, 0xffff, 0x0000, 1 },      
    { 0x000014fa, 0xffff, 0x0000, 1 },      
    { 0x000014fc, 0xffff, 0x0000, 1 },      
    { 0x000014fe, 0xffff, 0x0000, 1 },      
    { 0x00001500, 0xffff, 0x0000, 1 },      
    { 0x00001502, 0xffff, 0x0000, 1 },      
    { 0x00001504, 0xffff, 0x0000, 1 },      
    { 0x00001506, 0xffff, 0x0000, 1 },      
    { 0x00001508, 0xffff, 0x0000, 1 },      
    { 0x0000150a, 0xffff, 0x0000, 1 },      
    { 0x0000150c, 0xffff, 0x0000, 1 },      
    { 0x0000150e, 0xffff, 0x0000, 1 },      
    { 0x00001510, 0xffff, 0x0000, 1 },      
    { 0x00001512, 0xffff, 0x0000, 1 },      
    { 0x00001514, 0xffff, 0x0000, 1 },      
    { 0x00001516, 0xffff, 0x0000, 1 },      
    { 0x00001518, 0xffff, 0x0000, 1 },      
    { 0x0000151a, 0xffff, 0x0000, 1 },      
    { 0x0000151c, 0xffff, 0x0000, 1 },      
    { 0x0000151e, 0xffff, 0x0000, 1 },      
    { 0x00001520, 0x0001, 0x000f, 1 },      
    { 0x00001520, 0x0003, 0x000d, 1 },      
    { 0x00001520, 0x00ff, 0x0000, 1 },      
    { 0x00001522, 0x0fff, 0x0000, 1 },      
    { 0x00001524, 0x0fff, 0x0000, 1 },      
    { 0x00001526, 0x0fff, 0x0000, 1 },      
    { 0x00001528, 0x0fff, 0x0000, 1 },      
    { 0x0000152a, 0xffff, 0x0000, 1 },      
    { 0x0000152c, 0xffff, 0x0000, 1 },      
    { 0x0000152e, 0xffff, 0x0000, 1 },      
    { 0x00001530, 0xffff, 0x0000, 1 },      
    { 0x00001540, 0x0003, 0x000c, 1 },      
    { 0x00001540, 0x0003, 0x0008, 1 },      
    { 0x00001540, 0x0001, 0x0006, 1 },      
    { 0x00001540, 0x0001, 0x0004, 1 },      
    { 0x00001540, 0x0001, 0x0002, 1 },      
    { 0x00001540, 0x0001, 0x0000, 1 },      
    { 0x00001542, 0x07ff, 0x0000, 1 },      
    { 0x00001544, 0x07ff, 0x0000, 1 },      
    { 0x00001546, 0x0fff, 0x0000, 1 },      
    { 0x00001548, 0x07ff, 0x0000, 1 },      
    { 0x0000154a, 0x0fff, 0x0000, 1 },      
    { 0x0000154c, 0x07ff, 0x0000, 1 },      
    { 0x0000154e, 0x07ff, 0x0000, 1 },      
    { 0x00001550, 0x0fff, 0x0000, 1 },      
    { 0x00001552, 0x07ff, 0x0000, 1 },      
    { 0x00001554, 0x07ff, 0x0000, 1 },      
    { 0x00001556, 0x00ff, 0x0008, 1 },      
    { 0x00001556, 0x00ff, 0x0000, 1 },      
    { 0x00001558, 0x00ff, 0x0008, 1 },      
    { 0x00001558, 0x00ff, 0x0000, 1 },      
    { 0x0000155a, 0x00ff, 0x0000, 1 },      
    { 0x0000155c, 0x07ff, 0x0000, 1 },      
    { 0x0000155e, 0x07ff, 0x0000, 1 },      
    { 0x00001560, 0x07ff, 0x0000, 1 },      
    { 0x00001564, 0x0003, 0x0008, 1 },      
    { 0x00001564, 0x0001, 0x0004, 1 },      
    { 0x00001564, 0x0001, 0x0000, 1 },      
    { 0x00001566, 0x0fff, 0x0000, 1 },      
    { 0x00001568, 0x0fff, 0x0000, 1 },      
    { 0x0000156a, 0x0fff, 0x0000, 1 },      
    { 0x0000156c, 0x0fff, 0x0000, 1 },      
    { 0x0000156e, 0x0fff, 0x0000, 1 },      
    { 0x00001570, 0x0fff, 0x0000, 1 },      
    { 0x00001572, 0x07ff, 0x0000, 1 },      
    { 0x00001574, 0x07ff, 0x0000, 1 },      
    { 0x00001576, 0x07ff, 0x0000, 1 },      
    { 0x00001578, 0x07ff, 0x0000, 1 },      
    { 0x0000157a, 0x0fff, 0x0000, 1 },      
    { 0x0000157c, 0x0fff, 0x0000, 1 },      
    { 0x0000157e, 0x0fff, 0x0000, 1 },      
    { 0x00001580, 0x07ff, 0x0000, 1 },      
    { 0x00001582, 0x07ff, 0x0000, 1 },      
    { 0x00001584, 0x07ff, 0x0000, 1 },      
    { 0x00001586, 0x0fff, 0x0000, 1 },      
    { 0x00001588, 0x07ff, 0x0000, 1 },      
    { 0x0000158a, 0x0fff, 0x0000, 1 },      
    { 0x0000158c, 0x07ff, 0x0000, 1 },      
    { 0x0000158e, 0x07ff, 0x0000, 1 },      
    { 0x00001590, 0x0fff, 0x0000, 1 },      
    { 0x00001592, 0x07ff, 0x0000, 1 },      
    { 0x00001594, 0x07ff, 0x0000, 1 },      
    { 0x00001596, 0x07ff, 0x0000, 1 },      
    { 0x00001598, 0x07ff, 0x0000, 1 },      
    { 0x0000159a, 0x07ff, 0x0000, 1 },      
    { 0x0000159c, 0x07ff, 0x0000, 1 },      
    { 0x00001564, 0x0001, 0x0001, 1 },      
    { 0x00001540, 0x0001, 0x0001, 1 },      
    { 0x00001426, 0x0003, 0x000e, 1 },      
    { 0x00001426, 0x0003, 0x0008, 1 },      
    { 0x00001426, 0x00ff, 0x0000, 1 },      
    { 0x00001428, 0xffff, 0x0000, 1 },      
    { 0x0000142a, 0xffff, 0x0000, 1 },      
    { 0x0000142c, 0xffff, 0x0000, 1 },      
    { 0x0000142e, 0xffff, 0x0000, 1 },      
};

/******************************************************************************
 Name       : Register Table of MB86H57 initialization parameter A
 Function   : To define the register address and field data for MB86H57
*******************************************************************************/
const struct fmb_param_table fmb_init_param_a[] = {
    { 0x00001802, 0x0fff, 0x0002, 1 },      
    { 0x00001802, 0x0003, 0x0000, 1 },      
    { 0x00001804, 0xffff, 0x0000, 1 },      
    { 0x00001806, 0x0001, 0x000e, 1 },      
    { 0x00001806, 0x0001, 0x000d, 1 },      
    { 0x00001806, 0x0003, 0x000b, 1 },      
    { 0x00001806, 0x0007, 0x0008, 1 },      
    { 0x00001806, 0x0001, 0x0007, 1 },      
    { 0x00001806, 0x0001, 0x0006, 1 },      
    { 0x00001806, 0x0003, 0x0004, 1 },      
    { 0x00001806, 0x0001, 0x0002, 1 },      
    { 0x00001806, 0x0001, 0x0001, 1 },      
    { 0x00001806, 0x0001, 0x0000, 1 },      
    { 0x00001808, 0x0001, 0x000e, 1 },      
    { 0x00001808, 0x0001, 0x000d, 1 },      
    { 0x00001808, 0x0003, 0x000b, 1 },      
    { 0x00001808, 0x0007, 0x0008, 1 },      
    { 0x00001808, 0x0001, 0x0007, 1 },      
    { 0x00001808, 0x0001, 0x0006, 1 },      
    { 0x00001808, 0x0003, 0x0004, 1 },      
    { 0x00001808, 0x0001, 0x0002, 1 },      
    { 0x00001808, 0x0001, 0x0001, 1 },      
    { 0x00001808, 0x0001, 0x0000, 1 },      
    { 0x0000180a, 0xffff, 0x0000, 1 },      
    { 0x0000180c, 0xffff, 0x0000, 1 },      
    { 0x0000180e, 0x0001, 0x000f, 1 },      
    { 0x0000180e, 0x0003, 0x0008, 1 },      
    { 0x0000180e, 0x0001, 0x0000, 1 },      
    { 0x00001810, 0xffff, 0x0000, 1 },      
    { 0x00001812, 0xffff, 0x0000, 1 },      
    { 0x00001818, 0xffff, 0x0000, 1 },      
    { 0x0000181a, 0xffff, 0x0000, 1 },      
    { 0x0000181c, 0xffff, 0x0000, 1 },      
    { 0x0000181e, 0xffff, 0x0000, 1 },      
    { 0x00001820, 0x0003, 0x0005, 1 },      
    { 0x00001820, 0x0001, 0x0004, 1 },      
    { 0x00001820, 0x0001, 0x0003, 1 },      
    { 0x00001820, 0x0003, 0x0000, 1 },      
    { 0x00001830, 0x0003, 0x0005, 1 },      
    { 0x00001830, 0x0001, 0x0004, 1 },      
    { 0x00001830, 0x0001, 0x0003, 1 },      
    { 0x00001830, 0x0003, 0x0001, 1 },      
    { 0x00001830, 0x0001, 0x0000, 1 },      
    { 0x00001850, 0x00ff, 0x0008, 1 },      
    { 0x00001850, 0x0001, 0x0005, 1 },      
    { 0x00001850, 0x0003, 0x0003, 1 },      
    { 0x00001850, 0x0003, 0x0001, 1 },      
    { 0x00001850, 0x0001, 0x0000, 1 },      
    { 0x00001852, 0xffff, 0x0000, 1 },      
    { 0x00001860, 0x000f, 0x0000, 1 },      
    { 0x00001880, 0x0007, 0x0005, 1 },      
    { 0x00001880, 0x0003, 0x0003, 1 },      
    { 0x00001880, 0x0001, 0x0002, 1 },      
    { 0x00001880, 0x0003, 0x0000, 1 },      
    { 0x000018b0, 0x0003, 0x0002, 1 },      
    { 0x000018b0, 0x0003, 0x0000, 1 },      
    { 0x000018c0, 0x0001, 0x000f, 1 },      
    { 0x000018c0, 0x000f, 0x0000, 1 },      
};

/******************************************************************************
 Name       : Register Table of MB86H57 vedio command
 Function   : To define the register address and field data for MB86H57
*******************************************************************************/
const struct fmb_param_table fmb_vedio_command[] = {
    { 0x00000000, 0x0001, 0x000f, 1 },      
    { 0x00000002, 0x00ff, 0x0000, 1 },      
    { 0x00000004, 0x0001, 0x0004, 1 },      
    { 0x00000004, 0x0001, 0x0002, 1 },      
    { 0x00000004, 0x0003, 0x0000, 1 },      
    { 0x00000006, 0x0003, 0x0000, 1 },      
    { 0x00000008, 0xffff, 0x0000, 1 },      
    { 0x0000000a, 0x0003, 0x0008, 1 },      
    { 0x0000000a, 0x0003, 0x0000, 1 },      
    { 0x0000000c, 0xffff, 0x0000, 1 },      
    { 0x00000010, 0xffff, 0x0000, 1 },      
    { 0x00000012, 0xffff, 0x0000, 1 },      
    { 0x00000014, 0xffff, 0x0000, 1 },      
    { 0x00000016, 0x0001, 0x0000, 1 },      
    { 0x00000100, 0xffff, 0x0000, 1 },      
    { 0x00000102, 0xffff, 0x0000, 1 },      
    { 0x00000104, 0xffff, 0x0000, 1 },      
    { 0x00000106, 0xffff, 0x0000, 1 },      
    { 0x00000108, 0xffff, 0x0000, 1 },      
    { 0x0000010a, 0xffff, 0x0000, 1 },      
    { 0x0000010c, 0xffff, 0x0000, 1 },      
    { 0x0000010e, 0xffff, 0x0000, 1 },      
    { 0x00000110, 0xffff, 0x0000, 1 },      
    { 0x00000112, 0xffff, 0x0000, 1 },      
    { 0x00000114, 0xffff, 0x0000, 1 },      
    { 0x00000116, 0xffff, 0x0000, 1 },      
    { 0x00000118, 0xffff, 0x0000, 1 },      
    { 0x0000011a, 0xffff, 0x0000, 1 },      
    { 0x0000011c, 0xffff, 0x0000, 1 },      
    { 0x0000011e, 0xffff, 0x0000, 1 },      
    { 0x00000120, 0xffff, 0x0000, 1 },      
    { 0x00000122, 0xffff, 0x0000, 1 },      
    { 0x00000124, 0xffff, 0x0000, 1 },      
    { 0x00000126, 0xffff, 0x0000, 1 },      
    { 0x00000128, 0xffff, 0x0000, 1 },      
    { 0x0000012a, 0xffff, 0x0000, 1 },      
    { 0x0000012c, 0xffff, 0x0000, 1 },      
    { 0x0000012e, 0xffff, 0x0000, 1 },      
    { 0x00000130, 0xffff, 0x0000, 1 },      
    { 0x00000132, 0xffff, 0x0000, 1 },      
    { 0x00000134, 0xffff, 0x0000, 1 },      
    { 0x00000136, 0xffff, 0x0000, 1 },      
    { 0x00000138, 0xffff, 0x0000, 1 },      
    { 0x0000013a, 0xffff, 0x0000, 1 },      
    { 0x0000013c, 0xffff, 0x0000, 1 },      
    { 0x0000013e, 0xffff, 0x0000, 1 },      
    { 0x00000140, 0xffff, 0x0000, 1 },      
    { 0x00000142, 0xffff, 0x0000, 1 },      
    { 0x00000144, 0xffff, 0x0000, 1 },      
    { 0x00000146, 0xffff, 0x0000, 1 },      
    { 0x00000148, 0xffff, 0x0000, 1 },      
    { 0x0000014a, 0xffff, 0x0000, 1 },      
    { 0x0000014c, 0xffff, 0x0000, 1 },      
    { 0x0000014e, 0xffff, 0x0000, 1 },      
    { 0x00000150, 0xffff, 0x0000, 1 },      
    { 0x00000152, 0xffff, 0x0000, 1 },      
    { 0x00000154, 0xffff, 0x0000, 1 },      
    { 0x00000156, 0xffff, 0x0000, 1 },      
    { 0x00000158, 0xffff, 0x0000, 1 },      
    { 0x0000015a, 0xffff, 0x0000, 1 },      
    { 0x0000015c, 0xffff, 0x0000, 1 },      
    { 0x0000015e, 0xffff, 0x0000, 1 },      
    { 0x00000160, 0xffff, 0x0000, 1 },      
    { 0x00000162, 0xffff, 0x0000, 1 },      
    { 0x00000164, 0xffff, 0x0000, 1 },      
    { 0x00000166, 0xffff, 0x0000, 1 },      
    { 0x00000168, 0xffff, 0x0000, 1 },      
    { 0x0000016a, 0xffff, 0x0000, 1 },      
    { 0x0000016c, 0xffff, 0x0000, 1 },      
    { 0x0000016e, 0xffff, 0x0000, 1 },      
    { 0x00000170, 0xffff, 0x0000, 1 },      
    { 0x00000172, 0xffff, 0x0000, 1 },      
    { 0x00000174, 0xffff, 0x0000, 1 },      
    { 0x00000176, 0xffff, 0x0000, 1 },      
    { 0x00000178, 0xffff, 0x0000, 1 },      
    { 0x0000017a, 0xffff, 0x0000, 1 },      
    { 0x0000017c, 0xffff, 0x0000, 1 },      
    { 0x0000017e, 0xffff, 0x0000, 1 },      
    { 0x00000180, 0xffff, 0x0000, 1 },      
    { 0x00000182, 0xffff, 0x0000, 1 },      
    { 0x00000184, 0xffff, 0x0000, 1 },      
    { 0x00000186, 0xffff, 0x0000, 1 },      
    { 0x00000188, 0xffff, 0x0000, 1 },      
    { 0x0000018a, 0xffff, 0x0000, 1 },      
    { 0x0000018c, 0xffff, 0x0000, 1 },      
    { 0x0000018e, 0xffff, 0x0000, 1 },      
    { 0x00000190, 0xffff, 0x0000, 1 },      
    { 0x00000192, 0xffff, 0x0000, 1 },      
    { 0x00000194, 0xffff, 0x0000, 1 },      
    { 0x00000196, 0xffff, 0x0000, 1 },      
    { 0x00000198, 0xffff, 0x0000, 1 },      
    { 0x0000019a, 0xffff, 0x0000, 1 },      
    { 0x0000019c, 0xffff, 0x0000, 1 },      
    { 0x0000019e, 0xffff, 0x0000, 1 },      
    { 0x000001a0, 0xffff, 0x0000, 1 },      
    { 0x000001a2, 0xffff, 0x0000, 1 },      
    { 0x000001a4, 0xffff, 0x0000, 1 },      
    { 0x000001a6, 0xffff, 0x0000, 1 },      
    { 0x000001a8, 0xffff, 0x0000, 1 },      
    { 0x000001aa, 0xffff, 0x0000, 1 },      
    { 0x000001ac, 0xffff, 0x0000, 1 },      
    { 0x000001ae, 0xffff, 0x0000, 1 },      
    { 0x000001b0, 0xffff, 0x0000, 1 },      
    { 0x000001b2, 0xffff, 0x0000, 1 },      
    { 0x000001b4, 0xffff, 0x0000, 1 },      
    { 0x000001b6, 0xffff, 0x0000, 1 },      
    { 0x000001b8, 0xffff, 0x0000, 1 },      
    { 0x000001ba, 0xffff, 0x0000, 1 },      
    { 0x000001bc, 0xffff, 0x0000, 1 },      
    { 0x000001be, 0xffff, 0x0000, 1 },      
    { 0x000001c0, 0xffff, 0x0000, 1 },      
    { 0x000001c2, 0xffff, 0x0000, 1 },      
    { 0x000001c4, 0xffff, 0x0000, 1 },      
    { 0x000001c6, 0xffff, 0x0000, 1 },      
    { 0x000001c8, 0xffff, 0x0000, 1 },      
    { 0x000001ca, 0xffff, 0x0000, 1 },      
    { 0x000001cc, 0xffff, 0x0000, 1 },      
    { 0x000001ce, 0xffff, 0x0000, 1 },      
    { 0x000001d0, 0xffff, 0x0000, 1 },      
    { 0x000001d2, 0xffff, 0x0000, 1 },      
    { 0x000001d4, 0xffff, 0x0000, 1 },      
    { 0x000001d6, 0xffff, 0x0000, 1 },      
    { 0x000001d8, 0xffff, 0x0000, 1 },      
    { 0x000001da, 0xffff, 0x0000, 1 },      
    { 0x000001dc, 0xffff, 0x0000, 1 },      
    { 0x000001de, 0xffff, 0x0000, 1 },      
    { 0x000001e0, 0xffff, 0x0000, 1 },      
    { 0x000001e2, 0xffff, 0x0000, 1 },      
    { 0x000001e4, 0xffff, 0x0000, 1 },      
    { 0x000001e6, 0xffff, 0x0000, 1 },      
    { 0x000001e8, 0xffff, 0x0000, 1 },      
    { 0x000001ea, 0xffff, 0x0000, 1 },      
    { 0x000001ec, 0xffff, 0x0000, 1 },      
    { 0x000001ee, 0xffff, 0x0000, 1 },      
    { 0x000001f0, 0xffff, 0x0000, 1 },      
    { 0x000001f2, 0xffff, 0x0000, 1 },      
    { 0x000001f4, 0xffff, 0x0000, 1 },      
    { 0x000001f6, 0xffff, 0x0000, 1 },      
    { 0x000001f8, 0xffff, 0x0000, 1 },      
    { 0x000001fa, 0xffff, 0x0000, 1 },      
    { 0x000001fc, 0xffff, 0x0000, 1 },      
    { 0x000001fe, 0xffff, 0x0000, 1 },      
};

/******************************************************************************
 Name       : Register Table of MB86H57 audio command
 Function   : To define the register address and field data for MB86H57
*******************************************************************************/
const struct fmb_param_table fmb_audio_command[] = {
    { 0x00000000, 0x0001, 0x000f, 1 },      
    { 0x00000002, 0x0001, 0x0000, 1 },      
    { 0x00000006, 0x0003, 0x0000, 1 },      
    { 0x00000008, 0xffff, 0x0000, 1 },      
    { 0x0000000a, 0xffff, 0x0000, 1 },      
    { 0x00000010, 0x0003, 0x0000, 1 },      
    { 0x00000012, 0x00ff, 0x0008, 1 },      
    { 0x00000012, 0x00ff, 0x0000, 1 },      
    { 0x00000014, 0xffff, 0x0000, 1 },      
    { 0x00000016, 0xffff, 0x0000, 1 },      
    { 0x00000018, 0xffff, 0x0000, 1 },      
    { 0x0000001a, 0xffff, 0x0000, 1 },      
};

const struct fmb_param_head_table g_Fmb_param_table[] = {
    { 0x0000,   &fmb_add_param_m[0],    SIZEOF_ARRAY(fmb_add_param_m)   },
    { 0x0001,   &fmb_add_param_v[0],    SIZEOF_ARRAY(fmb_add_param_v)   },
    { 0x0002,   &fmb_add_param_a[0],    SIZEOF_ARRAY(fmb_add_param_a)   },
    { 0x0003,   &fmb_init_param_m[0],   SIZEOF_ARRAY(fmb_init_param_m)  },
    { 0x0004,   &fmb_init_param_v[0],   SIZEOF_ARRAY(fmb_init_param_v)  },
    { 0x0005,   &fmb_init_param_a[0],   SIZEOF_ARRAY(fmb_init_param_a)  },
    { 0x0006,   &fmb_vedio_command[0],  SIZEOF_ARRAY(fmb_vedio_command)},
    { 0x0007,   &fmb_audio_command[0],  SIZEOF_ARRAY(fmb_audio_command)},
    { 0x0008,   NULL,           0               }
};
#endif /* 1102 The support schedule when the future.  */
