/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/****************************************************************************/
#ifndef __FMB_HWSUB_H
#define __FMB_HWSUB_H

#include <linux/pagemap.h>
#include <linux/usb.h>

#include "fmb_drv.h"

#define USB_VENDOR_ID_INTERNALROM          0x01221
#define USB_PRODUCT_ID_FUJITSU_MB86H57H58  0x0201e

#ifndef MB86E61_FUNCTION
#define USB_VENDOR_ID_FUJITSU              0x004C5
#define USB_PRODUCT_ID_FUJITSU_MB86E61     0x0202e
#endif /* not dfine MB86E61_FUNCTION */

#define USB_CMDTYPE_IN              0xC0
#define USB_CMDTYPE_OUT             0x40
#define USB_CMDREQ_SET_API_CMD      0xB8
#define USB_CMDREQ_CONTROL_REG      0xBC
#define USB_CMDREQ_CONTROL_I2C      0xBD
#define USB_CMDREQ_WRITE_SPI_STATE  0xC8
#define USB_CMDREQ_LOAD_FIRM        0xC9
#define USB_AMODE_RW                0x00
#define USB_AMODE_FiledW            0x01

/* i2c access mode type for usb */
#define USB_IMODE_NORMAL            0x0 /* Normal I2C_WRITE:0x00/READ:0x01 */
#define USB_IMODE_WITHOUT_STOP      0x1 /* I2C_WRITE(without STOP condition):0x02 */
#define USB_IMODE_REPEATED_START    0x2 /* I2C_READ(Repeated START condition):0x03 */
#define USB_IMODE_STOP              0x3 /* STOP condition:0x04 */
#define USB_IMODE_STATUS            0xf /* GET I2C STATUS */

#define FMB_USB_TRANS_BUFF_SIZE FMB_MMAP_BUFFER_SIZE
#define FMB_USB_TRANS_BUFF_NUM  FMB_MMAP_BUFFER_NUM


/* Get a minor range for your devices from the usb maintainer */
#define USB_FMB_MINOR_BASE      FMB_MINOR_BASE

#define MAX_TRANSFER        (PAGE_SIZE - 512)
#define WRITES_IN_FLIGHT    8



/* Define for interrupt transfer */
#define GET_CMD_ACK         0x10
#define GET_MSG             0x20
#define USB_CMDACK_SIZE     6   
#define USB_GETMSG_SIZE     3   
#define USB_INTR_MSG_MAXSIZE     USB_CMDACK_SIZE   // MAX size of usb interrupt transfer data
#ifdef MB86E61_FUNCTION
#define NOTIFY_FAILURE_MSG             0x21
#define USB_NOTIFY_FAILURE_MSG_SIZE    3   
#endif /* MB86E61_FUNCTION */


/* Define for bulk message timeout */
#define USB_BULK_MES_TIMEOUT_READ       10000 /* 10000[ms] : set value more than 1/HZ[s] */
#define USB_BULK_MES_TIMEOUT_THUMBNAIL  10000 /* 10000[ms] : set value more than 1/HZ[s] */

/**
 * USB internal command
 */
struct fmb_hw_usb_cmd {
    unsigned char       request;
    unsigned char       body[32];
    struct list_head        queue;
};

struct usb_thread_info{
    int thread_running;
    unsigned long timeout;
    void (*usb_handler)(int, void*);
};

/* Structure to hold all of our device specific stuff */
struct fmb_hw_usb {
    struct usb_device       *udev;                      /* usb device*/
    struct usb_interface    *interface;                 /* usb interface */
    struct semaphore        limit_sem;                  /* limiting the number of writes in progress */
    void                    *hw_priv_p;                 /* (struct fmb_hw_private * ) UP class Pointer*/
    unsigned char           *bulk_in_buffer;            /* receive data */
    size_t                  bulk_in_size;               /* size of receive buffer */
    __u8                    bulk_in_endpointAddr;       /* address of bulk in  endpoint */
    unsigned char           *bulk_in_buffer2;           /* receive data 2 */
    size_t                  bulk_in_size2;              /* size of receive 2 buffer */
    __u8                    bulk_in_endpointAddr2;      /* address of bulk in 2 endpoint */
    unsigned char           *bulk_out_buffer;            /* send data */
    size_t                  bulk_out_size;              /* size of send buffer */
    __u8                    bulk_out_endpointAddr;      /* address of bulk out endpoint */
    struct mutex            io_mutex;                   /* synchronize I/O with disconnect */
    struct mutex            i_mutex;                    /* synchronize I   with disconnect */
    struct mutex            i2_mutex;                   /* synchronize I2(read thumbnail)   with disconnect */
    struct mutex            o_mutex;                    /* synchronize O   with disconnect */
    struct usb_thread_info thread_info;
    struct completion       kt_comp;
    int (*wakeup_kthread)(struct fmb_hw_usb *hw_usb, unsigned long timeout);
    int (*wait_busystat)(struct fmb_hw_usb *hw_usb, unsigned long timeout);
    unsigned char           *bulk_in_buffer_read;       /* receive data */
    size_t                  bulk_in_size_read;          /* size of receive buffer */
    __u8                    bulk_in_endpointAddr_read;  /* address of read endpoint selector */
    __u8                    interrupt_in_endpointAddr;  /* address of interrupt in  endpoint */
    __u8                    control_in_endpointAddr;    /* address of control   in  endpoint */
    __u8                    control_out_endpointAddr;   /* address of control   out endpoint */
    unsigned char           *buffers[FMB_USB_TRANS_BUFF_NUM];          /* the buffers to transfer data */
    unsigned char           *buffers_useraddr[FMB_USB_TRANS_BUFF_NUM]; /* the memory-mapped user address for each buffer */
    int                     control_msg_only_flg;       /**< endpoint construction control message ony mode 1:true 0:false */
#ifdef USB_URB_FUNCTION
	struct urb              *interrupt_urb;             /* interrupt urb buffer */
	struct completion       interrupt_urb_done;         /* interrupt urb completion */
#endif
#ifdef DEBUGON_USB_ACCESS
    struct fmb_usb_debug_msg usb_debug_msg;
#endif /* DEBUGON_USB_ACCESS */
#ifdef MB86E61_FUNCTION
    struct fmb_cmd_ctl_info *cmd_ctl_info_apl;
    struct fmb_cmd_ctl_info *cmd_ctl_info_ep;
#endif /* MB86E61_FUNCTION */
    struct fmb_device_info  *device_info;
};



struct fmb_hw_usb_control_reg_data
{
    __u32 data;         /*< write bit data */
    __u32 write_enable; /*< write bit mask 0:disable 1:enable */
};
struct fmb_hw_usb_setup_packet
{
    __u8    bmRequestType;
    __u8    bRequest;
#ifdef MULTIENDIAN_FUNCTION
    __u16   wValue;
    __u16   wIndex;
    __u16   wLength;
#else
    union {
        struct {
            __u8    wValueL;
            __u8    wValueH;
        };
            __u16   wValueLH;
    };
    union {
        struct {
            __u8    wIndexL;
            __u8    wIndexH;
        };
            __u16   wIndexLH;
    };
    union {
        struct {
            __u8    wLengthL;
            __u8    wLengthH;
        };
            __u16   wLengthLH;
    };
#endif
};

struct fmb_hw_usb_setapicmd_param
{
    __u8 reserve0;              /*< reserve area */
    __u8 continuity_counter;    /*< continuity_counter of LSI COMMAND_register */
    __u8 cmd_ID;                /*< cmd_ID             of LSI COMMAND_register */
    __u8 sub_cmd_ID;            /*< sub_cmd_ID         of LSI COMMAND_register */
    __u16 body00;               /*< body00             of LSI COMMAND_register */
};

#define FMB_GET_HW_MINOR( lm, hwp ) \
{ \
    if ( hwp != NULL ) lm = ((struct fmb_hard_private *)hwp)->minor; \
    else lm = -1; \
}


int fmb_hw_usb_set_read_epaddr( struct fmb_hard_private* , int );

int fmb_hw_usb_ep_set_api_cmd( struct fmb_hw_usb *dev, struct fmb_hw_usb_setapicmd_param *cmd_param, int timeout );
int fmb_hw_usb_ep_control_reg( struct fmb_hw_usb *dev, int acs_mode, int io_mode, unsigned long addr, void *data, long data_size, int timeout );
int fmb_hw_usb_ep_control_i2c( struct fmb_hw_usb *dev, unsigned char acs_mode, int io_mode, unsigned char addr, void *data, unsigned short data_size, int timeout );
int fmb_hw_usb_ep_interrupt_read( struct fmb_hw_usb *dev, void *data, int size, int *actual_length, int timeout );
#ifdef MB86E61_FUNCTION
int fmb_hw_usb_ep_control_cmd( struct fmb_hw_usb *dev, struct fmb_cmd_ctl_info *cmd_ctl_info, int timeout );
#endif /* MB86E61_FUNCTION */

int fmb_hw_usb_open(struct inode *inode, struct file *file);
int fmb_hw_usb_release(struct inode *inode, struct file *file);

int     fmb_hw_usb_cmd( struct fmb_hw_usb *dev, struct fmb_hw_usb_setup_packet *setup_packet
    , int endpoint, void *data, long data_size, int timeout, int io_mode );
int fmb_hw_usb_thumbnail_read(struct fmb_hard_private *priv_p, struct fmb_read_thumbnail *read_thumbnail );
#endif /* __FMB_HWSUB_H */
