/*     Copyright (c) 1999-2005, Broadcom Corporation
 *     
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef BOARDMAP_H
#define BOARDMAP_H

/*****************************************************************************/
/*                    Include common chip definitions                        */
/*****************************************************************************/
#include "bcmmips.h"
#include "bchp_common.h"

/*****************************************************************************/
/*                    MIPS Physical Memory Map                               */
/*****************************************************************************/
#define CPU_PHYS_SDRAM_BASE	        0x00000000	/* SDRAM Base */
#define CPU_PHYS_ROM_BASE           0x1FC00000	/* ROM */
#define CPU_PHYS_FLASH_BASE         0x1C000000

/*****************************************************************************/
/*                   CPU to PCI Bridge Memory Map                            */
/*****************************************************************************/

#define CPU2PCI_CPU_PHYS_MEM_WIN_BASE     0xd0000000

/* Allow CPU to access PCI memory addresses 0xd0000000 to 0xdfffffff */
#define CPU2PCI_PCI_PHYS_MEM_WIN0_BASE    0xd0000000 /* Not used in A0 */
#define CPU2PCI_PCI_PHYS_MEM_WIN1_BASE    0xd0000000 /* Not used in A0 */
#define CPU2PCI_PCI_PHYS_MEM_WIN2_BASE    0xd0000000
#define CPU2PCI_PCI_PHYS_MEM_WIN3_BASE    0xd8000000

/* Allow CPU to access PCI I/O addresses 0xe0000000 to 0xe05fffff */
#define CPU2PCI_PCI_PHYS_IO_WIN0_BASE     0xe0000000
#define CPU2PCI_PCI_PHYS_IO_WIN1_BASE     0xe0200000
#define CPU2PCI_PCI_PHYS_IO_WIN2_BASE     0xe0400000


/*****************************************************************************/
/*                      PCI Physical Memory Map                              */
/*****************************************************************************/

/* PCI physical memory map */
#define PCI_7038_PHYS_ISB_WIN_BASE    0x10000000
#define PCI_7038_PHYS_MEM_WIN0_BASE   0x00000000
#define PCI_7038_PHYS_MEM_WIN1_BASE   0x02000000
#define PCI_7038_PHYS_MEM_WIN2_BASE   0x04000000

#define PCI_3250_PHYS_REG_WIN_BASE    0xd0000000
#define PCI_3250_PHYS_MEM_WIN_BASE    0xd1000000

#define PCI_7041_PHYS_MEM_WIN0_BASE   0xd2000000
#define PCI_7041_PHYS_MEM_WIN1_BASE   0xd2200000
#define PCI_7041_PHYS_MEM_WIN2_BASE   0xd2400000
#define PCI_7041_PHYS_MEM_WIN3_BASE   0xd2600000
#define PCI_7041_PHYS_MEM_WIN4_BASE   0xd2800000
#define PCI_7041_PHYS_MEM_WIN5_BASE   0xd2a00000

/*#define PCI_DEVICE_ID_7038      0x0e */
#define PCI_DEVICE_ID_EXT       0x0d
#define PCI_DEVICE_ID_7041      0x04
#define PCI_DEVICE_ID_3250      0x01
#define PCI_DEVICE_ID_SATA      0x0e

/*#define PCI_IDSEL_7038			(0x10000 << PCI_DEVICE_ID_7038) */
#define PCI_IDSEL_EXT           (0x10000 << PCI_DEVICE_ID_EXT)
#define PCI_IDSEL_7041          (0x10000 << PCI_DEVICE_ID_7041)
#define PCI_IDSEL_3250          (0x10000 << PCI_DEVICE_ID_3250)
#define PCI_IDSEL_SATA          (0x10000 << PCI_DEVICE_ID_SATA)

/*#define PCI_DEV_NUM_7038        (PCI_DEVICE_ID_7038 << 11) */
#define PCI_DEV_NUM_EXT         (PCI_DEVICE_ID_EXT  << 11)
#define PCI_DEV_NUM_7041        (PCI_DEVICE_ID_7041 << 11)
#define PCI_DEV_NUM_3250        (PCI_DEVICE_ID_3250 << 11)
#define PCI_DEV_NUM_SATA        (PCI_DEVICE_ID_SATA << 11)

#define DRAM_SIZE (128*1024*1024)

/*****************************************************************************/
/*                      MIPS Virtual Memory Map                              */
/*                                                                           */
/* Note that the addresses above are physical addresses and that programs    */
/* have to use converted addresses defined below:                            */
/*****************************************************************************/
#define DRAM_BASE_CACHE		BCM_PHYS_TO_K0(CPU_PHYS_SDRAM_BASE)   /* cached DRAM */
#define DRAM_BASE_NOCACHE	BCM_PHYS_TO_K1(CPU_PHYS_SDRAM_BASE)   /* uncached DRAM */
#define ROM_BASE_CACHE		BCM_PHYS_TO_K0(CPU_PHYS_ROM_BASE)
#define ROM_BASE_NOCACHE	BCM_PHYS_TO_K1(CPU_PHYS_ROM_BASE)
#define FLASH_BASE_NOCACHE  BCM_PHYS_TO_K1(CPU_PHYS_FLASH_BASE)

#define PCI_MEM_WIN_BASE    0xd0000000
#define PCI_MEM_WIN_SIZE    0x10000000
#define PCI_IO_WIN_BASE     0xe0000000
#define PCI_IO_WIN_SIZE     0x00600000

#define BCM7041_MEM_BASE    PCI_7041_PHYS_MEM_WIN0_BASE
#define BCM3250_REG_BASE    PCI_3250_PHYS_REG_WIN_BASE
#define BCM3250_MEM_BASE    PCI_3250_PHYS_MEM_WIN_BASE

/*****************************************************************************/
/* Include chip specific .h files                                            */
/*****************************************************************************/



#endif
