
EMULATOR    ?= NO

CONFIGMAKE = ./Config.make.tool
-include $(CONFIGMAKE)

LD	= $(LINK)
AR	= $(LIBRARIAN)
MAKE	?= gmake
CP	?= cp -pf
RM	?= rm -rf

ifeq ($(EMULATOR), NO)
	CROSS_BUILD ?= 1
else
	CROSS_BUILD ?= 0
endif
TARGETROOT ?= /usr/local
DEBUG_LEVEL ?= 0

ifneq ($(DEBUG_LEVEL),0)
	DEBUG_OPT = -DNTPDATE_DEBUG
	DEBUG_OPT2 = --enable-debugging
else
	DEBUG_OPT =
	DEBUG_OPT2 = --disable-debugging
endif

TARGET_SDIR = $(TARGETROOT)/sbin
TARGET_EDIR = $(TARGETROOT)/etc
MODULE_DIR	= ntpdate
MODULE		= ntpdate
MODULE_OBJ	= $(MODULE).out
MODULE_DEP	= $(MODULE).dpd

.PHONY: all install
all: Makefile $(MODULE_OBJ) install

$(MODULE_OBJ): Makefile $(MODULE_DIR)/$(MODULE)
	$(CP) $(MODULE_DIR)/$(MODULE) $(MODULE_OBJ)

ifeq ($(CROSS_BUILD),1)
Makefile:
	/bin/sh ./configure --prefix=$(TARGET_ROOT) --enable-ipv6 --target=mips-montavista-linux-gnu CC=$(CC) LD=$(LD) RANLIB=$(RANLIB) AR=$(AR) AS=$(AS) STRIP=$(STRIP) CFLAGS='-O2 -mips2 -Wall -fno-strict-aliasing $(DEBUG_OPT)' LDFLAGS=--static --host=mips-sharp-linux --build=i386-pc-linux $(DEBUG_OPT2)
else
Makefile:
	/bin/sh ./configure --prefix=$(TARGET_ROOT) --enable-ipv6 CC=$(CC) LD=$(LD) RANLIB=$(RANLIB) AR=$(AR) AS=$(AS) STRIP=$(STRIP) CFLAGS='-O2 -Wall -fno-strict-aliasing $(DEBUG_OPT)' LDFLAGS=--static $(DEBUG_OPT2)
endif

$(MODULE_DIR)/$(MODULE):
	cd $(MODULE_DIR); $(MAKE) -f Makefile
#	$(STRIP) $(MODULE_DIR)/$(MODULE)

install: $(MODULE_OBJ)
	sudo $(CP) $(MODULE_OBJ) $(TARGET_SDIR)

.PHONY: clean cleanall uninstall
clean:
	if [ -f Makefile ] ; then \
		$(MAKE) -f Makefile clean; \
	fi
	$(RM) $(MODULE_OBJ)

cleanall: clean
	sudo $(RM) $(TARGET_SDIR)/$(MODULE_OBJ)
	find . -name '*.Po' -exec $(RM) {} \;
	find . -name config.log -exec $(RM) {} \;
	find . -name config.status -exec $(RM) {} \;
	find . -name Makefile -exec $(RM) {} \;

uninstall:
	sudo $(RM) $(TARGET_SDIR)/$(MODULE_OBJ)

