/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/****************************************************************************/
#ifndef __FMB_API_H__
#define __FMB_API_H__

#include "fmb.h"

#define GET_CMD_ACK_RESET_MASK         0x40
#define GET_CMD_ACK_NOT_INCREMENT_MASK 0x80

/********************************************************/
/*		LSI Core Parameter Table		*/
/********************************************************/

struct fmb_param_table {
	unsigned long			offset;
	unsigned short			mask;
	unsigned short			shift;
	unsigned long			valid;
};

struct fmb_param_head_table {
	unsigned short			id_up_16bit;
	const struct fmb_param_table*	second_table_addr;
	unsigned long			second_table_size;
};

/********************************************************/
/*		ioctl External Function 		*/
/********************************************************/

/**
*  @brief	ioctl() Command Function
*  @param[in]	priv_p		hard private data pointer
*  @param[in]	cmd		Command number from application
*  @param[in,out]	arg	Argument from application
*  @return	0		normal end
*  @return	-EFAULT		user buffer(argp) access error
*  @return	-EINVAL		invalid content of parameter
*  @return	-ETIMEDOUT	timeout
*  @return	-ERESTARTSYS	internal error
*  @return	-EAGAIN		try again
*  @note	None
*/
int Fmb_api_ioctl(struct  fmb_hard_private* fmb_hard_private_data_p,
				unsigned int cmd,
				unsigned long arg
);


/********************************************************/
/*		systemcall basic API Function		*/
/********************************************************/
/**
*  @brief	Device Open Function
*  @param[in]	*ip		Information in filesystem
*  @param[in]	*fp		File pointer
*  @return	TBD
*  @note	None
*  @attention	None
*
int Fmb_api_open(struct inode* ip, struct file* fp);
*/

/**
*  @brief	Device Close Function
*  @param[in]	*ip		Information in filesystem
*  @param[in]	*fp		File pointer
*  @return	TBD
*  @note	None
*  @attention	None
int Fmb_api_release(struct inode* ip, struct file* fp);
*/

/**
*  @brief	Stream Receive Function from LSI.
*  @param[in]	*fmb_hard_private	Hard private data
*  @param[in]	*fp			File pointer
*  @param[in,out]	*buffp			Data pointer
*  @param[in]	len			Data length
*  @param[in]	*offset			Object pointer
*  @return	TBD
*  @note	None
*  @attention	None
*/
ssize_t Fmb_api_read(struct fmb_hard_private* fmb_hard_private_data_p,
			struct file* fill_p,
			const char __user* buff_p,
			size_t len,
			loff_t* offset
);

/**
*  @brief	Stream Send Function to LSI.
*  @param[in]	*fmb_hard_private	Hard private data
*  @param[in]	*fp			File pointer
*  @param[in,out]	*buffp		Data pointer
*  @param[in]	len			Data length
*  @param[in]	*offset			Object pointer
*  @return	TBD
*  @note	None
*  @attention	None
*/
ssize_t Fmb_api_write(struct fmb_hard_private* fmb_hard_private_data_p,
			struct file* fill_p,
			const char __user* buff_p,
			size_t len,
			loff_t* offset
);


#endif /* ifndef __FMB_API_H__ */
