/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/****************************************************************************/
#ifndef __FMB_HW_H__
#define __FMB_HW_H__

#include "fmb_msg.h"
#include "fmb_core.h"

/********************************************************/
/*  Constant definition for customizing     */
/********************************************************/
/** driver name */
#define FMB_DRIVER_NAME     "h57fmb"

/** FMB_API Linux driver system timer */
#ifdef MB86E61_FUNCTION
#define FMB_CODEC_CACK_SYS_TIME     10000 /* ms */
#else /* MB86E61_FUNCTION */
#define FMB_CODEC_CACK_SYS_TIME     2000 /* ms */
#endif /* MB86E61_FUNCTION */

#define FMB_MINOR_NUM_START 0
#define FMB_MINOR_BASE      248 //192
#define FMB_MAX_CARDS       8           /**< MAX card num  */

/* FMB Register Address */
#define FMB_REG_API_IRQEN   0x090078
#define FMB_REG_API_IRQEN2  0x0901B4
#define FMB_REG_API_IRQST   0x090074
#define FMB_REG_API_IRQST2  0x0901B0
#define FMB_REG_GPIO_IRQEN  0x09019C
#define FMB_REG_GPIO_IRQST  0x090198
#define FMB_REG_STATE       0x082008
#define FMB_REG_SPIROM_VER  0x080010
#define FMB_REG_SPIROM_VER_BYTE 0x0A


#define FMB_REG_GPIO_IRQ_XERROR_BIT (5)

/* Hard Event Infomation Area Address & size(2byte(16bit) x _NUM ) struct fmb_async_info en_mask */
/* Notification message of FMB_FACT_STATE */
#define FMB_EVENT_STATE_CHAGE_ADDR          0x082008    /* to 0x082008    2byte */
#define FMB_EVENT_STATE_CHAGE_NUM                  1

/* Notification message of FMB_FACT_PCR_IN */
#define FMB_EVENT_PCR_ADDR                  0x082010    /* to 0x08201f   16byte */
#define FMB_EVENT_PCR_NUM                          8

/* Notification message of FMB_FACT_STREAM_BUFF */
#define FMB_EVENT_STREAM_BUFF_ADDR          0x082020    /* to 0x08202f   16byte */
#define FMB_EVENT_STREAM_BUFF_NUM                  8

/* Notification message of FMB_FACT_PID_IN */
#define FMB_EVENT_PID_ADDR                  0x082030    /* to 0x0820ff  208byte */
#define FMB_EVENT_PID_NUM                        104

/* Notification message of FMB_FACT_I2C */
#define FMB_EVENT_I2C_ADDR                  0x0823be    /* to 0x0823ff   66byte */
#define FMB_EVENT_I2C_NUM                         33

/* Notification message of FMB_FACT_BCAS_STATE */
#define FMB_EVENT_BCAS_STATE_CHANGE_ADDR    0x0822ac    /* to 0x0823bd  274byte */
#define FMB_EVENT_BCAS_STATE_CHANGE_NUM          137

/* Notification message of FMB_FACT_BCAS_DATA */
#define FMB_EVENT_BCAS_DATA_RET_ADDR        0x0822ac    /* to 0x0823bd  274byte */
#define FMB_EVENT_BCAS_DATA_RET_NUM              137

/* Notification message of FMB_FACT_SECURE */
#define FMB_EVENT_SECURE_ADDR               0x083200    /* to 0x0833ff  512byte */
#define FMB_EVENT_SECURE_NUM                     256

/* Notification message of FMB_FACT_VFRAME_ERR */
#define FMB_EVENT_VFRAME_ERR_ADDR           0x082100    /* to 0x08211f   32byte */
#define FMB_EVENT_VFRAME_ERR_NUM                  16

/* Notification message of FMB_FACT_VFRAME */
#define FMB_EVENT_VFRAME_ADDR               0x082100    /* to 0x08211f   32byte */
#define FMB_EVENT_VFRAME_NUM                      16

/* Notification message of FMB_FACT_AFRAME */
#define FMB_EVENT_AFRAME_ADDR               0x082120    /* to 0x08213f   32byte */
#define FMB_EVENT_AFRAME_NUM                      16

/* Notification message of FMB_FACT_STREAM_SIZE */
#define FMB_EVENT_STREAM_SIZE_ADDR          0x082140    /* to 0x08214f   16byte */
#define FMB_EVENT_STREAM_SIZE_NUM                  8

/* Notification message of FMB_FACT_STREAM_SIZE2 */
#define FMB_EVENT_STREAM_SIZE2_ADDR         0x082150    /* to 0x08215f   16byte */
#define FMB_EVENT_STREAM_SIZE2_NUM                 8

/* Notification message of FMB_FACT_GOP_INFO */
#define FMB_EVENT_GOP_INFO_ADDR             0x082160    /* to 0x08217f   32byte */
#define FMB_EVENT_GOP_INFO_NUM                    16

/* Notification message of FMB_FACT_GOP_INFO2 */
#define FMB_EVENT_GOP_INFO2_ADDR            0x082180    /* to 0x08218f   32byte */
#define FMB_EVENT_GOP_INFO2_NUM                   16

/* Notification message of FMB_FACT_XERROR */
#define FMB_EVENT_XERROR_ADDR               0x080080    /* to 0x08008f   16byte */
#define FMB_EVENT_XERROR_NUM                       8


/********************************************************/
/*  USB adress                                          */
/********************************************************/
/** USB register size **/
#define FMB_CORE_LSI_SIZE           0x001DFFFC

/**
 *  @brief      The hardware-dependent part of private data<br>
 */
struct fmb_hard_private
{
    void*                           dev_priv;       /**< device private pointer */
    int                             minor;          /**< minor number */
    int                             minor_num;      /**< private data nummber */
    struct fmb_core_private*        core_priv_p;    /**< core private data pointer*/
    struct kref                     kref;           /**< kref struct */
    char                            spirom_ver[FMB_REG_SPIROM_VER_BYTE];   /**< spirom version */
};

struct fmb_hw_obj
{
    struct file_operations  fops;
};

#define to_fmb_hard_private_ptr(d) container_of(d, struct fmb_hard_private, kref)

#define PRIV_P_CHECK( p, r )       if ( p == NULL ) return r
#define PRIV_P_CHECK_VOID( p, r )  if ( p == NULL ) return
//#define PRIV_P_CHECK_VOID( p, r )  if ( p == NULL ) { err("%s(%d) null object code=%d", __FILE__, __LINE__, r ); return; }

#define PARAM_CHECK( p, r )        if ( p == NULL ) return r
//#define PARAM_CHECK( p, r )
//#define PARAM_CHECK_VOID( p, r, m )  if ( p == NULL ) return
#define PARAM_CHECK_VOID( p, r, m )   if ( p == NULL ) { err("%03d:%s(%d) null param code=%d", m, __FILE__, __LINE__, r ); return; }

/********************************************************/
/*  FMB Hardware External Function                      */
/********************************************************/

/**
*   @brief      Register Read to LSI
*   @param[in]  priv_p          private data pointer
*   @param[in]  addr            LSI register address
*   @return     val             register read value
*   @note       None
*   @attention  None
*/  
unsigned short Fmb_hw_reg_read_lsi(struct fmb_hard_private* priv_p, unsigned long addr, int *result );

/**
*   @brief      Register Read to LSI ( 32bit )
*   @param[in]  priv_p          private data pointer
*   @param[in]  addr            LSI register address
*   @return     val             register read value
*   @note       None
*   @attention  None
*/  
unsigned long Fmb_hw_reg_read_lsi32(struct fmb_hard_private* priv_p, unsigned long addr, int *result );

/**
*   @brief      Register Write to LSI
*   @param[in]  priv_p          private data pointer
*   @param[in]  addr            LSI register address
*   @param[in]  data            register write value
*   @return     None
*   @note       None
*   @attention  None
*/  
void Fmb_hw_reg_write_lsi(struct fmb_hard_private* priv_p, unsigned long addr, unsigned short data, int *result );

#if 0 /* 1102 The support schedule when the future.  */
/**
*   @brief      Register Read to USB(master)
*   @param[in]  priv_p          private data pointer
*   @param[in]  addr            DMA register address
*   @return     val             register read value
*   @note       None
*   @attention  None
*/
unsigned long Fmb_hw_reg_read_lsi_master(struct fmb_hard_private* priv_p, unsigned long addr);

/**
*   @brief      Register Write to USB(master)
*   @param[in]  priv_p          private data pointer
*   @param[in]  addr            LSI register address
*   @param[in]  data            register write value
*   @return     None
*   @note       None
*   @attention  None
*/  
void Fmb_hw_reg_write_lsi_master(struct fmb_hard_private* priv_p, unsigned long addr, unsigned long data);

#endif /* 1102 The support schedule when the future.  */

/**
*   @brief      Register Read Modfi Write to LSI
*   @param[in]  priv_p          private data pointer
*   @param[in]  addr            LSI register address
*   @param[in]  shift           shift value at the time of writing
*   @param[in]  mask            mask value at the time of writing
*   @param[in]  data            register write value
*   @return     val         register read value
*   @note       None
*   @attention  None
*/
int Fmb_hw_reg_rmw_lsi32(struct fmb_hard_private* priv_p, unsigned long addr, unsigned long mask, unsigned long data);

/**
*   @brief  Check access area for lsi
*   @param[in]  priv_p          private data pointer
*   @param[in]  offset_addr offset address to specified USB
*   @param[in]  access_size Size of access area
*   @return 0       Normal end
*   @return -EINVAL     The content of the parameter is illegal.
*   @note   None
*   @attension  None
*/
int Fmb_hw_check_addr_lsi(struct fmb_hard_private* priv_p, unsigned long offset_addr, unsigned long access_size);

/**
*   @brief      FMB Codec Lsi Reset
*   @param[in]  priv_p          private data pointer
*   @return     None
*   @note       None
*   @attention  None
*/
struct fmb_hard_private* fmb_hw_private_alloc( void );
void   fmb_hw_private_free( void );
void   fmb_hw_private_data_init(struct fmb_hard_private* priv_p);
void   fmb_hw_private_data_release(struct fmb_hard_private* priv_p);

int     fmb_hw_device_open(  struct inode* ip_p, struct file* fp_p  );
int     fmb_hw_device_release( struct inode* ip_p, struct file* fp_p );
int     fmb_hw_device_ioctl( struct fmb_hard_private* priv_hw_p, unsigned int cmd, unsigned long arg );
int     fmb_hw_device_register( void );
void    fmb_hw_device_unregister( void );
unsigned short fmb_hw_device_reg_read(struct fmb_hard_private* priv_p, unsigned long addr, int *result );
unsigned long fmb_hw_device_reg_read32(struct fmb_hard_private* priv_p, unsigned long addr, int *result );
void           fmb_hw_device_reg_write(struct fmb_hard_private* priv_p, unsigned long addr, unsigned short data, int *result );
#if 0 /* 1102 The support schedule when the future.  */
unsigned long  fmb_hw_device_reg_read_master(struct fmb_hard_private* priv_p, unsigned long addr);
void           fmb_hw_device_reg_write_master(struct fmb_hard_private* priv_p, unsigned long addr, unsigned long data);
#endif /* 1102 The support schedule when the future.  */
int fmb_hw_device_reg_rmw32(struct fmb_hard_private* priv_p, unsigned long addr, unsigned long mask, unsigned long data);

int fmb_hw_is_exist_intr( struct fmb_hard_private *hw_priv_p );

#endif /* ifndef __FMB_HW_H__ */
