#!/bin/sh

KERN_RELEASE=`uname -r`
LIBDIR="/lib/modules/$KERN_RELEASE/$MDIR"

module="h57fmb"

#
# Check root account
#
uid=`id | sed 's/uid=//' | sed 's/(.*//'`
if [ $uid != 0 ]; then
    echo "ERROR: You are not root.!!"
    exit
fi

#
# Edit /etc/rc.d/rc.local
#
grep h57fmb /etc/rc.d/rc.local
if [ $? != 0 ];then
    echo "/etc/rc.d/rc6.d/S99$module" >> /etc/rc.d/rc.local
fi

#
# Copy restart script
#
\cp S99$module /etc/rc.d/rc6.d/
chmod 755 /etc/rc.d/rc6.d/S99$module

#
# Copy udev rules
#
if [ -d /etc/udev/rules.d ];then
    \cp 60-h57fmb.rules /etc/udev/rules.d
    chmod 644 /etc/udev/rules.d/60-h57fmb.rules
fi

#
# Unload old driver module
#
grep $module /proc/modules
if [ $? = 0 ];then
    echo -n "Unloading old device driver..."
    /sbin/rmmod $module
    echo "done."
fi

#
# Install new driver module
#
echo "Making device driver..."
make clean
make
make install
echo "done."

#
# Load new driver module
#
echo -n "Loading new device driver..."
/sbin/insmod $LIBDIR/$module.ko
# /sbin/insmod $LIBDIR/$module.ko msg_lvl=1023
# /sbin/insmod $LIBDIR/$module.ko msg_lvl=511
echo "done."

