/* Copyright (C) 2005, 2009 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#include <string.h>
#include <sysdep.h>


/* Copy memory like memcpy, but no return value required.  Can't alias
   to memcpy because it's not defined in the same translation
   unit.  Also for Neon we need to save the vector registers, since
   memcpy may clobber them.  */
#if defined(__ARM_NEON__)
  void __attribute__((naked))
  __aeabi_memcpy (void *dest, const void *src, size_t n)
  {
    asm("fmrx	r3, fpscr\n\t"
        "push	{r3, lr}\n\t"
#ifdef __GCC_HAVE_DWARF2_CFI_ASM
	CFI_ADJUST_CFA_OFFSET (8) "\n\t"
	CFI_REL_OFFSET (lr, 4) "\n\t"
	CFI_REMEMBER_STATE "\n\t"
#endif
        "vpush	{d0-d7}\n\t"
	/* Per the AAPCS, memcpy itself has to care for {d8-d15}.  */
#ifdef __GCC_HAVE_DWARF2_CFI_ASM
	CFI_ADJUST_CFA_OFFSET (8 * 8) "\n\t"
	CFI_REL_OFFSET (256, 0 * 8) "\n\t"
	CFI_REL_OFFSET (257, 1 * 8) "\n\t"
	CFI_REL_OFFSET (258, 2 * 8) "\n\t"
	CFI_REL_OFFSET (259, 3 * 8) "\n\t"
	CFI_REL_OFFSET (260, 4 * 8) "\n\t"
	CFI_REL_OFFSET (261, 5 * 8) "\n\t"
	CFI_REL_OFFSET (262, 6 * 8) "\n\t"
	CFI_REL_OFFSET (263, 7 * 8) "\n\t"
	CFI_REMEMBER_STATE "\n\t"
#endif
        "vpush	{d16-d31}\n\t"
#ifdef __GCC_HAVE_DWARF2_CFI_ASM
	CFI_ADJUST_CFA_OFFSET (16 * 8) "\n\t"
	CFI_REL_OFFSET (272, 0 * 8) "\n\t"
	CFI_REL_OFFSET (273, 1 * 8) "\n\t"
	CFI_REL_OFFSET (274, 2 * 8) "\n\t"
	CFI_REL_OFFSET (275, 3 * 8) "\n\t"
	CFI_REL_OFFSET (276, 4 * 8) "\n\t"
	CFI_REL_OFFSET (277, 5 * 8) "\n\t"
	CFI_REL_OFFSET (278, 6 * 8) "\n\t"
	CFI_REL_OFFSET (279, 7 * 8) "\n\t"
	CFI_REL_OFFSET (280, 8 * 8) "\n\t"
	CFI_REL_OFFSET (281, 9 * 8) "\n\t"
	CFI_REL_OFFSET (282, 10 * 8) "\n\t"
	CFI_REL_OFFSET (283, 11 * 8) "\n\t"
	CFI_REL_OFFSET (284, 12 * 8) "\n\t"
	CFI_REL_OFFSET (285, 13 * 8) "\n\t"
	CFI_REL_OFFSET (286, 14 * 8) "\n\t"
	CFI_REL_OFFSET (287, 15 * 8) "\n\t"
#endif
        "bl	memcpy\n\t"
        "vpop	{d16-d31}\n\t"
#ifdef __GCC_HAVE_DWARF2_CFI_ASM
	CFI_RESTORE_STATE "\n\t"
#endif
        "vpop	{d0-d7}\n\t"
#ifdef __GCC_HAVE_DWARF2_CFI_ASM
	CFI_RESTORE_STATE "\n\t"
#endif
        "pop	{r3, lr}\n\t"
#ifdef __GCC_HAVE_DWARF2_CFI_ASM
	CFI_ADJUST_CFA_OFFSET (-8) "\n\t"
	CFI_RESTORE (lr) "\n\t"
#endif
        "fmxr	fpscr, r3\n\t"
        "bx	lr");
  }
#else
  void
  __aeabi_memcpy (void *dest, const void *src, size_t n)
  {
    memcpy (dest, src, n);
  }
#endif

/* Versions of the above which may assume memory alignment.  */
strong_alias (__aeabi_memcpy, __aeabi_memcpy4)
strong_alias (__aeabi_memcpy, __aeabi_memcpy8)
