/*
 * Copyright (c) 2006-2010 by Panasonic Corporation
 *
 *  All rights reserved.
 *
 */

#ifndef __SYS__DFOSD_H__
#define __SYS__DFOSD_H__


/* CUSTOMIZE SECTION */
#if SOC_TYPE == 2
#define  DFOSD_SETTING                    \
  {                                       \
    { 960,  540, DSPF_ARGB     },  /* ID0 */    \
    { 960,  540, DSPF_LUT8     },  /* ID1 */    \
    { 960,  540, DSPF_ARGB     },  /* ID2 */    \
    { 960,  540, DSPF_ARGB4444 },  /* ID3 */    \
  }
#else

#ifndef LAYER_SIZE_SELECT
#ifndef DTV_SETTING
#define DTV_SETTING 9999
#endif
#define LAYER_SIZE_SELECT DTV_SETTING
#endif
#if LAYER_SIZE_SELECT == 8
#define  DFOSD_SETTING                    \
  {                                       \
    { 1920,  1080, DSPF_ARGB },  /* ID0 (confirm your setting) */    \
    {    0,     0, DSPF_UNKNOWN },  /* ID1 (confirm your setting) */    \
    {    0,     0, DSPF_UNKNOWN },  /* ID2 (confirm your setting) */    \
    {    0,     0, DSPF_UNKNOWN },  /* ID3 (confirm your setting) */    \
  }
#elif LAYER_SIZE_SELECT == 9
#define  DFOSD_SETTING                    \
  {                                       \
    { 1920,  1080, DSPF_ARGB },  /* ID0 (confirm your setting) */    \
    { 1920,  1080, DSPF_ARGB },  /* ID1 (confirm your setting) */    \
    { 1920,  1080, DSPF_ARGB },  /* ID2 (confirm your setting) */    \
    { 1920,  1080, DSPF_NV12 },  /* ID3 (confirm your setting) */    \
  }
#elif LAYER_SIZE_SELECT == 10
#define  DFOSD_SETTING                    \
  {                                       \
    { 1920,  1080, DSPF_ARGB },  /* ID0 (confirm your setting) */    \
    {    0,     0, DSPF_UNKNOWN },  /* ID1 (confirm your setting) */    \
    {    0,     0, DSPF_UNKNOWN },  /* ID2 (confirm your setting) */    \
    {    0,     0, DSPF_UNKNOWN },  /* ID3 (confirm your setting) */    \
  }
#elif LAYER_SIZE_SELECT == 3
#define  DFOSD_SETTING                    \
  {                                       \
    { 1920,  1080, DSPF_ARGB },  /* ID0 (confirm your setting) */    \
    { 1920,  1080, DSPF_LUT8 },  /* ID1 (confirm your setting) */    \
    { 1920,  1080, DSPF_ARGB },  /* ID2 (confirm your setting) */    \
    { 1920,  1080, DSPF_NV12 },  /* ID3 (confirm your setting) */    \
  }
#else
/* LAYER_SIZE_SELECT Undefined */
#endif

#endif

typedef enum {
  DFOSD_ID0 = 0,
  DFOSD_ID1 = 1,
  DFOSD_ID2 = 2,
  DFOSD_ID3 = 3,
  DFOSD_ID_LAST,
} DFOSD_ID;

#define LUT_SIZE (256*4*4)
#define DEV_EXMEM "/dev/exmem"

/*
 * DFOSD_PLANE structure
 */
#define DFOSD_MAX_SURFACE_BUFFERS 3
typedef struct {

  int                   magic;
  void                 *fb_base[DFOSD_MAX_SURFACE_BUFFERS];      /* mapped fb address     */
  unsigned long         smem_buffer[DFOSD_MAX_SURFACE_BUFFERS];
  unsigned long         smem_paddr[DFOSD_MAX_SURFACE_BUFFERS];
  unsigned long         smem_len;
  unsigned long         bits_per_pixel;
  unsigned long         xres;
  unsigned long         yres;
  void                 *lut_base[1];     /* mapped lut address    */
  unsigned long         lut_offset;   /* physical lut address  */
  unsigned long         lut_size;   /* physical lut map size  */
  unsigned long         lut_pbase;  /*  lut address  */
  CorePalette            *palette;    /* palette               */
  CoreSurface            *primary;      /* primary surface       */
  CoreSurfacePool        *dfosd_pool;
  SurfaceManager         *manager;      /* surfacemanager        */
  int                   buffermode;   /* buffermode            */
  DFBSurfacePixelFormat pixelformat;  /* surface pixelformat   */
  FusionSkirmish        lock;         /* lock                  */
  int                   map_size;     /* mmap size             */
  bool                  addr_config;
} DFOSD_PLANE;

/*
 * DFOSD_PLANE structure
 */
typedef struct _DFOSD_DEVICE {

  CoreDFB              *core;                 /* directfb core      */
  DFOSD_PLANE           planes[DFOSD_ID_LAST];/* osd plane          *//* shared */
  DFOSD_ID              primary_id;           /* primary layer id   */
  void                 *logical_base;         /* logical video ram  */
  unsigned int          physical_base;        /* physical video ram */
  unsigned int          video_mem[3];        /* video memory [0]:lbase/[1]pbase/[2]length      */
  void                 *driver_data;          /* GraphicsDriver data */
  void                 *device_data;          /* GraphicsDevice data */
  CoreSurface          *accum_surface[4];     /* shared */
  unsigned int          num_accum_surface;    /* shared */
  FusionSkirmish        lock;                 /* shared */
  struct _DFOSD_DEVICE *shared;               /* shared */
  SurfaceManager       *manager;
} DFOSD_DEVICE;



#endif
