/*
 *  u-boot/arch/arm/cpu/armv7/cache.S
 *
 *  Copyright (C) 2001 Deep Blue Solutions Ltd.
 *  Copyright (C) 2005 ARM Ltd.
 *  Copyright (C) 2011 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  This is the "shell" of the ARMv7 processor support.
 */

#include <config.h>
#include <asm/system.h>

	.macro	dcache_line_size, reg, tmp
	mrc	p15, 1, \tmp, c0, c0, 0		@ read CSIDR
	and	\tmp, \tmp, #7			@ cache line size encoding
	mov	\reg, #16			@ size offset
	mov	\reg, \reg, lsl \tmp		@ actual cache line size
	.endm

/*
 *	invalidate_L1_icache_all()
 */
.global invalidate_L1_icache_all
invalidate_L1_icache_all:
	mov	r0, #0
	mcr	p15, 0, r0, c7, c1, 0		@ invalidate I-cache inner shareable
	mov	pc, lr

/*
 *	flush_L1_dcache_all()
 */
.global flush_L1_dcache_all
flush_L1_dcache_all:
	stmfd	sp!, {r4-r5, r7, r9-r11, lr}
	bl	_flush_L1_dcache_all
	ldmfd	sp!, {r4-r5, r7, r9-r11, lr}
	mov	pc, lr

_flush_L1_dcache_all:
	dmb					@ ensure ordering with previous memory accesses
	mrc	p15, 1, r0, c0, c0, 1		@ read clidr
	ands	r3, r0, #0x7000000		@ extract loc from clidr
	mov	r3, r3, lsr #23			@ left align loc bit field
	beq	finished			@ if loc is 0, then no need to clean
	mov	r10, #0				@ start clean at cache level 0
loop1:
	add	r2, r10, r10, lsr #1		@ work out 3x current cache level
	mov	r1, r0, lsr r2			@ extract cache type bits from clidr
	and	r1, r1, #7			@ mask of the bits for current cache only
	cmp	r1, #2				@ see what cache we have at this level
	blt	skip				@ skip if no cache, or just i-cache
	mcr	p15, 2, r10, c0, c0, 0		@ select current cache level in cssr
	isb					@ isb to sych the new cssr&csidr
	mrc	p15, 1, r1, c0, c0, 0		@ read the new csidr
	and	r2, r1, #7			@ extract the length of the cache lines
	add	r2, r2, #4			@ add 4 (line length offset)
	ldr	r4, =0x3ff
	ands	r4, r4, r1, lsr #3		@ find maximum number on the way size
	clz	r5, r4				@ find bit position of way size increment
	ldr	r7, =0x7fff
	ands	r7, r7, r1, lsr #13		@ extract max number of the index size
loop2:
	mov	r9, r4				@ create working copy of max way size
loop3:
	orr	r11, r10, r9, lsl r5		@ factor way and cache number into r11
	orr	r11, r11, r7, lsl r2		@ factor index number into r11
	mcr	p15, 0, r11, c7, c14, 2		@ clean & invalidate by set/way
	subs	r9, r9, #1			@ decrement the way
	bge	loop3
	subs	r7, r7, #1			@ decrement the index
	bge	loop2
skip:
	add	r10, r10, #2			@ increment cache number
	cmp	r3, r10
	bgt	loop1
finished:
	mov	r10, #0				@ swith back to cache level 0
	mcr	p15, 2, r10, c0, c0, 0		@ select current cache level in cssr
	dsb
	isb
	mov	pc, lr

/*
 *	flush_L1_cache_all()
 */
.global flush_L1_cache_all
flush_L1_cache_all:
	stmfd	sp!, {r4-r5, r7, r9-r11, lr}
	bl	flush_L1_dcache_all
	mov	r0, #0
	mcr	p15, 0, r0, c7, c1, 0		@ invalidate I-cache inner shareable
	ldmfd	sp!, {r4-r5, r7, r9-r11, lr}
	mov	pc, lr

/*
 *	invalidate_L1_dcache_range(start, stop)
 */
.global invalidate_L1_dcache_range
invalidate_L1_dcache_range:
	dcache_line_size r2, r3
	sub	r3, r2, #1
	tst	r0, r3
	bic	r0, r0, r3
#ifdef CONFIG_ARM_ERRATA_764369
	dsb
	dsb
#endif
	mcrne	p15, 0, r0, c7, c14, 1		@ clean & invalidate D / U line

	tst	r1, r3
	bic	r1, r1, r3
	mcrne	p15, 0, r1, c7, c14, 1		@ clean & invalidate D / U line
1:
	mcr	p15, 0, r0, c7, c6, 1		@ invalidate D / U line
	add	r0, r0, r2
	cmp	r0, r1
	blo	1b
	dsb
	mov	pc, lr

/*
 *	flush_L1_dcache_range(start, stop)
 */
.global flush_L1_dcache_range
flush_L1_dcache_range:
	dcache_line_size r2, r3
	sub	r3, r2, #1
	bic	r0, r0, r3
#ifdef CONFIG_ARM_ERRATA_764369
	dsb
	dsb
#endif
1:
	mcr	p15, 0, r0, c7, c14, 1		@ clean & invalidate D / U line
	add	r0, r0, r2
	cmp	r0, r1
	blo	1b
	dsb
	mov	pc, lr

/*
 *	flush_L1_cache_range(start, stop)
 */
.global flush_L1_cache_range
flush_L1_cache_range:
	dcache_line_size r2, r3
	sub	r3, r2, #1
	bic	r0, r0, r3
#ifdef CONFIG_ARM_ERRATA_764369
	dsb
	dsb
#endif
1:
	mcr	p15, 0, r0, c7, c14, 1		@ clean & invalidate D / U line
	dsb
	mcr	p15, 0, r0, c7, c5, 1		@ invalidate I line
	add	r0, r0, r2
	cmp	r0, r1
	blo	1b
	mov	r0, #0
	mcr	p15, 0, r0, c7, c1, 6		@ invalidate BTB Inner Shareable
	dsb
	isb
	mov	pc, lr

/*
 *	turn_off_dcache()
 */
.global turn_off_dcache
turn_off_dcache:
	stmfd	sp!, {r4-r5, r7, r9-r11, lr}
	mrc	p15, 0, r0, c1, c0
	bic	r0, r0, #CR_C			@ clear D-cache enable bit
	mcr	p15, 0, r0, c1, c0
#ifndef CONFIG_L1_OFF
	bl	_flush_L1_dcache_all
#endif /* !CONFIG_L1_OFF */
#ifndef CONFIG_L2_OFF
	bl	flush_L2_dcache_all
#endif /* !CONFIG_L2_OFF */
	ldmfd	sp!, {r4-r5, r7, r9-r11, lr}
	mov	pc, lr
