/*
 * Copyright (C) 2011 Panasonic Corporation
 * All Rights Reserved.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/arch/cacheflush.h>

#if !(defined(CONFIG_L1_OFF) && defined(CONFIG_L2_OFF))
extern unsigned long mn_addr_trans(unsigned long vaddr);
#endif /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */

#ifndef CONFIG_L1_OFF
static void vaddr_purge_L1cache(unsigned long start, unsigned long size, int flag)
{
	switch (flag) {
	case PURGE_CACHE_D_PURGE_INV:
		flush_L1_dcache_range(start, start + size);
		break;
	case PURGE_CACHE_D_INV:
		invalidate_L1_dcache_range(start, start + size);
		break;
	default: /* Not support other flag in u-boot. */
		break;
	}
	return;
}
#else /* !CONFIG_L1_OFF */
#define vaddr_purge_L1cache(start, size, flag) do {} while(0)
#endif /* !CONFIG_L1_OFF */

#ifndef CONFIG_L2_OFF
static void purge_L2cache(unsigned long start, unsigned long size, int flag)
{
	unsigned long end = start + size;
	if (end <= start)	return;

	if (flag == PURGE_CACHE_D_PURGE_INV) {
		flush_L2_dcache_range(start, end);
	}else if (flag == PURGE_CACHE_D_INV){
		invalidate_L2_dcache_range(start, end);
	}
}
#else /* !CONFIG_L2_OFF */
#define purge_L2cache(vstart, size, flag) do {} while(0)
#endif /* !CONFIG_L2_OFF */

void vaddr_purge_cache(unsigned long vstart, unsigned long size, int flags)
{
#if !(defined(CONFIG_L1_OFF) && defined(CONFIG_L2_OFF))
	unsigned long i, w, paddr;

	for (i = 0; i < size; i += w) {
		w = PAGE_SIZE - ((vstart + i) & ~PAGE_MASK);
		if ((size - i) < w) {
			w = size - i;
		}
		paddr = mn_addr_trans(vstart + i);
		if (paddr != 0) {
			vaddr_purge_L1cache(vstart + i, w, flags);
			purge_L2cache(paddr, w, flags);
		}
	}
#endif /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */
}
