/*****************************************************************************
 *
 * ethernet_util.c -- MAC address function parts
 *
 *
 * Copyright (C) 2010, Panasonic Corporation
 *
 * History
 *  v0.1: Framework draft
 *****************************************************************************/


#define _USE_EEPROM

#ifdef _USE_EEPROM /**************************************************/
#include <common.h>
#include <asm/system.h>
//#include <asm/arch/irq.h>
#include <asm/io.h>
#include <asm/arch/cpu-regs.h>
//#include <asm/arch/intctl-regs.h>
#include <asm/arch/timer-regs.h>

extern int eep_get_mac(unsigned char *mac_addr);
#endif /* _USE_EEPROM ************************************************/

/***************************************************/
/* MAC address get function  (Please modify here)  */
/***************************************************/
int util_mac_read(unsigned char *mac_buf);
int util_mac_read(unsigned char *mac_buf)
{
  int ret;

  mac_buf[0] = 0xff;
  mac_buf[1] = 0xff;
  mac_buf[2] = 0xff;
  mac_buf[3] = 0xff;
  mac_buf[4] = 0xff;
  mac_buf[5] = 0xff;

  ret = eep_get_mac(mac_buf);

  return(ret);
}

/**************************************************************************/
#ifdef _USE_EEPROM /**************************************************/

#define EEPROM_ADDRESS  (0xA2)
#define MAC_OFFSET      (0xFFF9)

#ifdef CONFIG_USE_BOARD_OPTION_C
#define USE_IIC_CH      (1)       /* 0,1,2,3 */
#else
#define USE_IIC_CH      (2)       /* 0,1,2,3 */
#endif

#define IIC_OFFSET      (0x80000 * USE_IIC_CH)

#define IIC_BASE        (0x58400000)
#define IIC_DTRM        __SYSREG(IIC_BASE + IIC_OFFSET)
#define IIC_DREC        __SYSREG(IIC_BASE + 0x04 + IIC_OFFSET)
#define IIC_MYADD       __SYSREG(IIC_BASE + 0x08 + IIC_OFFSET)
#define IIC_CLK         __SYSREG(IIC_BASE + 0x0c + IIC_OFFSET)
#define IIC_BRST        __SYSREG(IIC_BASE + 0x10 + IIC_OFFSET)
#define IIC_HOLD        __SYSREG(IIC_BASE + 0x14 + IIC_OFFSET)
#define IIC_BSTS        __SYSREG(IIC_BASE + 0x18 + IIC_OFFSET)

#define IIC_IRQ                 (73 + USE_IIC_CH)
#define IIC_GIC_PEND_CLR        __SYSREG(0x20001280 + (IIC_IRQ / 32) * 4)
#define IIC_GIC_PEND_MASK       (1 << (IIC_IRQ % 32))

#define IIC_CLK_PLS	((unsigned short)(IOCLK / 100000 - 1))
#define IIC_CLK_LOW	((unsigned short)(IIC_CLK_PLS / 2))

#define SYS_IIC_DTRM_Bit_STA	((unsigned short)0x0400)
#define SYS_IIC_DTRM_Bit_STO	((unsigned short)0x0200)
#define SYS_IIC_DTRM_Bit_ACK	((unsigned short)0x0100)
#define SYS_IIC_DTRM_Bit_DATA	((unsigned short)0x00FF)


#define inl(a)			(*((volatile unsigned long*)(a)))
#define outl(d, a)		(*((volatile unsigned long*)(a)) = d)

#if 1
#define POLL_INT_REQ(icr)		udelay(1000);

#else

#define POLL_INT_REQ(icr)                                       \
do {                                                            \
        while (!(inl(IIC_GIC_PEND_CLR) & IIC_GIC_PEND_MASK));   \
        mn_intc_clear(IIC_IRQ);                                 \
} while (0)
#endif

int eep_get_mac(unsigned char mac_addr[])
{
	unsigned char *mac_buf = mac_addr;
	unsigned short value;
	unsigned int data;
	int mac_length = 6;

	outl(0x00000008, IIC_MYADD);
	outl((IIC_CLK_LOW << 16) + (IIC_CLK_PLS), IIC_CLK);
	outl(0x00000003, IIC_BRST);

	value	=  SYS_IIC_DTRM_Bit_STA | SYS_IIC_DTRM_Bit_ACK;
	value	|= ((unsigned short)EEPROM_ADDRESS & SYS_IIC_DTRM_Bit_DATA) | (unsigned short)0x0000;
	outl(value, IIC_DTRM);
	POLL_INT_REQ();

	/** send offset of MAC address in EEPROM **/
	outl((unsigned char)((MAC_OFFSET & 0xFF00) >> 8), IIC_DTRM);
	POLL_INT_REQ();

	outl((unsigned char)(MAC_OFFSET & 0x00FF), IIC_DTRM);
	POLL_INT_REQ();

	udelay (1000);

	value	=  SYS_IIC_DTRM_Bit_STA;
	value	|= ((unsigned short)EEPROM_ADDRESS & SYS_IIC_DTRM_Bit_DATA) | (unsigned short)0x0001;
	outl(value, IIC_DTRM);
	POLL_INT_REQ();

	outl(0x00000000, IIC_DTRM);
	while (mac_length > 0) {
		POLL_INT_REQ();

		data = inl(IIC_DREC);
		mac_length--;
		if (mac_length == 0) {
			/* stop IIC bus */
			value = 0x00000300;
		}
		else if (mac_length == 1) {
			/* no ack */
			value = 0x00000100;
		}
		else {
			/* ack */
			value = 0x00000000;
		}
		outl(value, IIC_DTRM);
		*mac_buf++ = (unsigned char)(data & 0xff);
	}

	return 0;
}
#endif /* _USE_EEPROM ************************************************/
/**************************************************************************/



