/*
 * Copyright (C) 2010 Panasonic Corporation
 * All Rights Reserved.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software ;  you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation ;  either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY ;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program ;  if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <asm/system.h>

/* When lowlevel_init is called, STACK has not be set yet. */
.global lowlevel_init
lowlevel_init:

#ifdef CONFIG_UNIPHIER_MMU_ENABLE
__enable_mmu:
	mrc	p15, 0, r0, c1, c0, 0		@ read control reg
	orr	r0, r0, #CR_M			@ set MMU enable bit
#ifndef CONFIG_L1_OFF
	orr	r0, r0, #CR_C			@ set D-cache enable bit
#endif /* !CONFIG_L1_OFF */

__turn_mmu_on:
	mcr	p15, 0, r0, c1, c0, 0		@ write control reg
	mrc	p15, 0, r3, c0, c0, 0		@ read id reg
#endif /* CONFIG_UNIPHIER_MMU_ENABLE */

	mov	pc, lr

.global disable_mmu
disable_mmu:
#ifdef CONFIG_UNIPHIER_MMU_ENABLE
	mrc	p15, 0, r0, c1, c0, 0		@ read control reg
	bic	r0, r0, #CR_M			@ clear MMU enable bit
	mcr	p15, 0, r0, c1, c0, 0		@ write control reg
	mcr	p15, 0, r0, c8, c7		@ TLB disable
#endif /* CONFIG_UNIPHIER_MMU_ENABLE */
	mov	pc, lr
