/*
 * Copyright (C) 2010 Panasonic Corporation
 * All Rights Reserved.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <command.h>
#include <asm/arch/serial-regs.h>
#include <asm/arch/timer-regs.h>

/*
 * Local function prototypes
 */

/*
 * Minimal global serial functions needed to use one of the SCI modules.
 */

#ifdef CONFIG_UNIPHIER_SERIAL_HIGH_SPEED		/* High Speed serial */
#define SCTXB		SC4TDR
#define SCRXB		SC4RDR
#define SCWAIT_TBF	while (!(*SC4LSR & SC4LSR_TDRE)) continue;
#define SCWAIT_RBF	while (!(*SC4LSR & SC4LSR_RDR)) continue;
#define SCCHECK_RBF	(*SC4LSR & SC4LSR_RDR)

#else	/* Low Speed serial */
#error "No Support Low Speed serial"
#endif	/* CONFIG_UNIPHIER_SERIAL_HIGH_SPEED */


int serial_init (void)
{
	DECLARE_GLOBAL_DATA_PTR;

	/* Set Serial Port */
#ifdef CONFIG_UNIPHIER_SERIAL_HIGH_SPEED
	*SC4FCR = SC4FCR_FEN;
	*SC4LCR = SC4LCR_CHL;
#endif	/* CONFIG_UNIPHIER_SERIAL_HIGH_SPEED */

	/* Set baudrate */
	*SC4DLR = UARTCLK / (gd->baudrate) / 16;

	return 0;
}

void serial_putc(const char c)
{
	SCWAIT_TBF
    *SCTXB = c;
    if (c == 0x0a) {
		SCWAIT_TBF
		*SCTXB = 0x0d;
	}
}

int serial_getc(void)
{
	int c = '\0';

	SCWAIT_RBF
	c = *SCRXB;	
	if(c == 0x0d)
		c = 0x0a;
	return c;	
}

int serial_tstc()
{
	return SCCHECK_RBF;
}

void serial_setbrg (void)
{
	serial_init();
	return;
}

void serial_puts (const char *s)
{
	while (*s) {
		serial_putc(*s);
		++s;
	}
}
