/* UniPhier Cache flushing
 *
 * Copyright (C) 2007 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public Licence
 * as published by the Free Software Foundation; either version
 * 2 of the Licence, or (at your option) any later version.
 */
#ifndef _ASM_ARCH_CACHEFLUSH_H
#define _ASM_ARCH_CACHEFLUSH_H

#undef PAGE_SIZE
#define PAGE_SIZE		4096
#define PAGE_MASK		(~(PAGE_SIZE-1))

#define L1_CACHE_SHIFT		(5)		/* CONFIG_ARM_L1_CACHE_SHIFT */
#define L1_CACHE_BYTES		(1 << L1_CACHE_SHIFT)

#ifndef CONFIG_L2_OFF
#define L2_CACHE_SHIFT		(7)
#define L2_CACHE_BYTES		(1 << L2_CACHE_SHIFT)

#define L2_CACHE_ADRS_MASK	(~(L2_CACHE_BYTES - 1))
#endif /* CONFIG_L2_OFF */

//#define PURGE_CACHE_D_PURGE	0x00
#define PURGE_CACHE_D_PURGE_INV	0x01
//#define PURGE_CACHE_ID_SYNC	0x02
#define PURGE_CACHE_D_INV	0x03
//#define PURGE_CACHE_I_INV	0x04

#define	SIZE_ALL_CACHE		0xffffffffUL

/* Inner function */
#if !(defined(CONFIG_L1_OFF) && defined(CONFIG_L2_OFF))
#define invalidate_icache_all() invalidate_L1_icache_all()
#define invalidate_dcache_all()			do {} while(0)
#define clean_dcache_all()			do {} while(0)
#define flush_dcache_all()			do {} while(0)
extern void flush_cache_all(void);
#define coherent_dcache_all()			do {} while(0)
#define invalidate_icache_range(start, stop)	do {} while(0)
extern void flush_dcache_range(unsigned long start, unsigned long stop);
extern void flush_cache_range(unsigned long start, unsigned long stop);
extern void coherent_dcache_range(unsigned long start, unsigned long stop);
#else /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */
#define invalidate_icache_all()			do {} while(0)
#define invalidate_dcache_all()			do {} while(0)
#define clean_dcache_all()			do {} while(0)
#define flush_dcache_all()			do {} while(0)
#define flush_cache_all()			do {} while(0)
#define coherent_dcache_all()			do {} while(0)
#define invalidate_icache_range(start, stop)	do {} while(0)
#define flush_dcache_range(start, stop)		do {} while(0)
#define flush_cache_range(start, stop)		do {} while(0)
#define coherent_dcache_range(start, stop)	do {} while(0)
#endif /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */

/* L1 Cache */
#ifndef CONFIG_L1_OFF
#define invalidate_L1_icache_all(void);		/* for cleanup_before_linux() */
#define invalidate_L1_dcache_all()		do {} while(0)
#define clean_L1_dcache_all()			do {} while(0)
extern void flush_L1_dcache_all(void);		/* for flush_L1_cache_all() */
extern void flush_L1_cache_all(void);
#define coherent_L1_dcache_all()		do {} while(0)
extern void invalidate_L1_dcache_range(unsigned long start, unsigned long stop);
#define clean_L1_dcache_range()			do {} while(0)
extern void flush_L1_dcache_range(unsigned long start, unsigned long stop);
extern void flush_L1_cache_range(unsigned long start, unsigned long stop);
#define coherent_L1_cache_range()		do {} while(0)
#else /* !CONFIG_L1_OFF */
#define invalidate_L1_icache_all()		do {} while(0)
#define invalidate_L1_dcache_all()		do {} while(0)
#define clean_L1_dcache_all()			do {} while(0)
#define flush_L1_dcache_all()			do {} while(0)
#define flush_L1_cache_all()			do {} while(0)
#define coherent_L1_dcache_all()		do {} while(0)
#define invalidate_L1_dcache_range(start, stop)	do {} while(0)
#define clean_L1_dcache_range()			do {} while(0)
#define flush_L1_dcache_range(start, stop)	do {} while(0)
#define flush_L1_cache_range(start, stop)	do {} while(0)
#define coherent_L1_cache_range()		do {} while(0)
#endif /* !CONFIG_L1_OFF */

/* L2 Cache */
#ifndef CONFIG_L2_OFF
#define invalidate_L2_dcache_all()		do {} while(0)
#define clean_L2_dcache_all()			do {} while(0)
extern void flush_L2_dcache_all(void);
#define coherent_L2_dcache_all() clean_L2_dcache_all()
extern void invalidate_L2_dcache_range(unsigned long start, unsigned long stop);
#define clean_L2_dcache_range()			do {} while(0)
extern void flush_L2_dcache_range(unsigned long start, unsigned long stop);
#define coherent_L2_cache_range(start, stop) clean_L2_dcache_range((start), (stop))
#else /* !CONFIG_L2_OFF */
#define invalidate_L2_dcache_all()		do {} while(0)
#define clean_L2_dcache_all()			do {} while(0)
#define flush_L2_dcache_all()			do {} while(0)
#define coherent_L2_dcache_all()		do {} while(0)
#define invalidate_L2_dcache_range(start, stop)	do {} while(0)
#define clean_L2_dcache_range(start, stop)	do {} while(0)
#define flush_L2_dcache_range(start, stop)	do {} while(0)
#define coherent_L2_cache_range(start, stop)	do {} while(0)
#endif /* !CONFIG_L2_OFF */

#endif /* _ASM_ARCH_CACHEFLUSH_H */
