/*
 * Copyright (C) 2010 Panasonic Corporation
 * All Rights Reserved.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef _ASM_ARCH_SERIAL_REGS_H
#define _ASM_ARCH_SERIAL_REGS_H

#include <asm/arch/cpu-regs.h>

#define UARTCLK			36864000

#define UNIPHIER_UART_REG_SHIFT	0

#define UNIPHIER_UART_RX	0x00
#define UNIPHIER_UART_TX	0x00
#define UNIPHIER_UART_IER	0x04
#define UNIPHIER_UART_IIR	0x08
#define UNIPHIER_UART_FCR	0x0c
#define UNIPHIER_UART_LCR	0x10
#define UNIPHIER_UART_MCR	0x10
#define UNIPHIER_UART_LSR	0x14
#define UNIPHIER_UART_MSR	0x18
#define UNIPHIER_UART_DLL	0x24

#define UNIPHIER_UART_LCR_WLEN8	(UART_LCR_WLEN8<<8)

/* serial port 4 */
#define	SC4RDR				__SYSREGB(CONFIG_UNIPHIER_SERIAL_BASE)		/* receive buffer reg */
#define	SC4TDR				__SYSREGB(CONFIG_UNIPHIER_SERIAL_BASE)		/* transmit buffer reg */

#define	SC4IER				__SYSREGB(CONFIG_UNIPHIER_SERIAL_BASE + UNIPHIER_UART_IER)		/* interrupt control reg */

#define	SC4IIR				__SYSREGB(CONFIG_UNIPHIER_SERIAL_BASE + UNIPHIER_UART_IIR)		/* interrupt indication reg */

#define	SC4FCR				__SYSREGB(CONFIG_UNIPHIER_SERIAL_BASE + UNIPHIER_UART_FCR)		/* FIFO control reg */
#define	SC4FCR_TFR			0x04											/* transmit FIFO reset */
#define	SC4FCR_RFR			0x02											/* receive FIFO reset */
#define	SC4FCR_FEN			0x01											/* FIFO enable */

#define	SC4LCR				__SYSREGH(CONFIG_UNIPHIER_SERIAL_BASE + UNIPHIER_UART_LCR)		/* line control reg */
#define	SC4LCR_BRC			0x4000											/* transmit brake */
#define	SC4LCR_STP			0x2000											/* select parity */
#define	SC4LCR_EPS			0x1000											/* enable parity */
#define	SC4LCR_PE			0x0800											/* stop bit length */
#define	SC4LCR_CHL			0x0300											/* character length */

#define	SC4MCR				__SYSREGH(CONFIG_UNIPHIER_SERIAL_BASE + UNIPHIER_UART_MCR)		/* modem control reg */
#define	SC4MCR_AFE			0x0020											/* auto flow control */
#define	SC4MCR_LPT			0x0010											/* select clock source */
#define	SC4MCR_RTS			0x0002											/* XRTS output level */

#define	SC4LSR				__SYSREGB(CONFIG_UNIPHIER_SERIAL_BASE + UNIPHIER_UART_LSR)		/* line status reg */
#define	SC4LSR_FFE			0x80											/* FIFO error */
#define	SC4LSR_TE			0x40											/* transmit status */
#define	SC4LSR_TDRE			0x20											/* buffer status */
#define	SC4LSR_BRI			0x10											/* brake interrupt */
#define	SC4LSR_FME			0x08											/* frame error */
#define	SC4LSR_PTE			0x04											/* parity error */
#define	SC4LSR_OVE			0x02											/* overrun error */
#define	SC4LSR_RDR			0x01											/* receive status */

#define	SC4MSR				__SYSREGB(CONFIG_UNIPHIER_SERIAL_BASE + UNIPHIER_UART_MSR)		/* modem status reg */

#define SC4DLR				__SYSREGH(CONFIG_UNIPHIER_SERIAL_BASE + UNIPHIER_UART_DLL)		/* baudrate set reg */

#endif /* _ASM_ARCH_SERIAL_REGS_H */
