#ifndef SH_UTIL_H
#define SH_UTIL_H

#define UNIPHIER_PIO_BASE		0x55000000	/* P.A. */
#define UNIPHIER_PIO_OFFSET		0x00000008

#define PIO_IOD_REG(PORT)	(UNIPHIER_PIO_BASE + 0x08 + UNIPHIER_PIO_OFFSET*(PORT))
#define PIO_DIR_REG(PORT)	(UNIPHIER_PIO_BASE + 0x0c + UNIPHIER_PIO_OFFSET*(PORT))

static inline void vWrPort(unsigned int uiPort, unsigned int uiBit, unsigned int uiSet )
{
	unsigned int uiAddr ;
	unsigned int uiVal ;

	uiAddr = PIO_IOD_REG(uiPort);
	
	if ( uiSet != 0 ) {
		uiVal = *((volatile unsigned int*)uiAddr) | (1 << uiBit ) ;
	} else {
		uiVal = *((volatile unsigned int*)uiAddr) & (~(1 << uiBit) ) ;
	}

	*((volatile unsigned int*)uiAddr) = uiVal ;
}

static inline unsigned int uiRdPort(unsigned int uiPort, unsigned int uiBit)
{
	unsigned int uiAddr ;

	uiAddr = PIO_IOD_REG(uiPort);

	if ( *((volatile unsigned int*)uiAddr) & (1 << uiBit ) ) {
		return 1 ;
	} else {
		return 0 ;
	}
}

/* 0: internal flash 1: external flash */
static inline unsigned int get_ext_boot( void )
{
	// 1ji
	return uiRdPort(10, 5);
}

/* 0: on-board boot 1: ext-boot */
static inline unsigned int get_n_jig_con( void )
{
	return uiRdPort(10, 6);
}

static inline void chg_nand_ce( void )
{
	if ( get_n_jig_con() ) {
		// ext -> on-board
		vWrPort(8, 0, 1);
	} else {
		// on-board -> ext
		vWrPort(14, 1, 1);
	}
}

static inline void set_led0( unsigned int val )
{
	vWrPort(1, 6, val);
}

static inline void set_led1( unsigned int val )
{
	vWrPort(1, 5, val);
}

#endif
