/*
 * Copyright (C) 2010 Panasonic Corporation
 * All Rights Reserved.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef _ASM_CPU_TIMER_REGS_H
#define _ASM_CPU_TIMER_REGS_H

#include <asm/arch/cpu-regs.h>
#include <config.h>

/* IOCLK */
#define IOCLK				(100000000UL)

#define	TM4MD			__SYSREGH(0x54003080)	/* timer 4 mode register */
#define	TM4MD_SRC		0x07	/* timer source */
#define	TM4MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM4MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM4MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM4MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM4MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM4MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM4MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM4MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM5MD			__SYSREGH(0x54003082)	/* timer 5 mode register */
#define	TM5MD_SRC		0x07	/* timer source */
#define	TM5MD_SRC_IOCLK		0x00	/* - IOCLK */
#define	TM5MD_SRC_IOCLK_8	0x01	/* - 1/8 IOCLK */
#define	TM5MD_SRC_IOCLK_32	0x02	/* - 1/32 IOCLK */
#define	TM5MD_SRC_TM4CASCADE	0x03	/* - cascade with timer 4 */
#define	TM5MD_SRC_TM0UFLOW	0x04	/* - timer 0 underflow */
#define	TM5MD_SRC_TM1UFLOW	0x05	/* - timer 1 underflow */
#define	TM5MD_SRC_TM2UFLOW	0x06	/* - timer 2 underflow */
#define	TM5MD_SRC_TM7UFLOW	0x07	/* - timer 7 underflow */
#define	TM5MD_INIT_COUNTER	0x40	/* initialize TMnBC = TMnBR */
#define	TM5MD_COUNT_ENABLE	0x80	/* timer count enable */

#define	TM4BR			__SYSREGH(0x54003090)	/* timer 4 base register */
#define	TM5BR			__SYSREGH(0x54003092)	/* timer 5 base register */
#define	TM45BR			__SYSREG(0x54003090)	/* timer 4:5 base register */

#define	TM4BC			__SYSREGH(0x540030a0)	/* timer 4 binary counter */
#define	TM5BC			__SYSREGH(0x540030a2)	/* timer 5 binary counter */
#define	TM45BC			__SYSREG(0x540030a0)	/* timer 4:5 binary counter */

#endif /* _ASM_CPU_TIMER_REGS_H */
