/*
 * (C) Copyright 2002
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/* for now: just dummy functions to satisfy the linker */

#include <common.h>

#ifdef CONFIG_UNIPHIER
#if !(defined(CONFIG_L1_OFF) && defined(CONFIG_L2_OFF))
#include <asm/arch/cacheflush.h>
#include <asm/system.h>

unsigned long mn_addr_trans(unsigned long vaddr)
{
#ifdef CONFIG_USE_IRQ
	unsigned long flags;
#endif /* CONFIG_USE_IRQ */
	unsigned long ret;

#ifdef CONFIG_USE_IRQ
	local_irq_save(flags);
#endif /* CONFIG_USE_IRQ */

	__asm__ __volatile__(
"	mcr	p15, 0, %1, c7, c8, 0\n"
"	mrc	p15, 0, %0, c7, c4, 0\n"
"	tst	%0, #1\n"
"	movne	%0, #0\n"
	: "=r" (ret)
	: "r" (vaddr)
	: "cc");

#ifdef CONFIG_USE_IRQ
	local_irq_restore(flags);
#endif /* CONFIG_USE_IRQ */

	ret = (ret & PAGE_MASK) | (vaddr & ~PAGE_MASK);
	return ret;
}
#endif /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */

void flush_cache(unsigned long start_addr, unsigned long size)
{
#if !(defined(CONFIG_L1_OFF) && defined(CONFIG_L2_OFF))
	unsigned long stop_addr = start_addr + size;
	if (start_addr >= stop_addr) {
		return;
	}

	flush_cache_range(start_addr, stop_addr);
#endif /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */
	return;
}

void flush_cache_all(void)
{
#if !(defined(CONFIG_L1_OFF) && defined(CONFIG_L2_OFF))
	flush_L1_cache_all();
	flush_L2_dcache_all();
#endif /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */
	return;
}

void invalidate_dcache_range(unsigned long start, unsigned long stop)
{
#if !(defined(CONFIG_L1_OFF) && defined(CONFIG_L2_OFF))
	unsigned long size, vaddr, paddr;

	for (vaddr = start; vaddr < stop; vaddr += size) {
		size = PAGE_SIZE - (vaddr & ~PAGE_MASK);
		if (size > stop - vaddr) {
			size = stop - vaddr;
		}

		paddr = mn_addr_trans(vaddr);
		if (paddr) {
			invalidate_L1_dcache_range(vaddr, vaddr + size);
			invalidate_L2_dcache_range(paddr, paddr + size);
		}
	}
#endif /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */

	return;
}

void flush_dcache_range(unsigned long start, unsigned long stop)
{
#if !(defined(CONFIG_L1_OFF) && defined(CONFIG_L2_OFF))
	unsigned long size, vaddr, paddr;

	for (vaddr = start; vaddr < stop; vaddr += size) {
		size = PAGE_SIZE - (vaddr & ~PAGE_MASK);
		if (size > stop - vaddr) {
			size = stop - vaddr;
		}

		paddr = mn_addr_trans(vaddr);
		if (paddr) {
			flush_L1_dcache_range(vaddr, vaddr + size);
			flush_L2_dcache_range(paddr, paddr + size);
		}
	}
#endif /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */

	return;
}

void flush_cache_range(unsigned long start, unsigned long stop)
{
#if !(defined(CONFIG_L1_OFF) && defined(CONFIG_L2_OFF))
	unsigned long size, vaddr, paddr;

	for (vaddr = start; vaddr < stop; vaddr += size) {
		size = PAGE_SIZE - (vaddr & ~PAGE_MASK);
		if (size > stop - vaddr) {
			size = stop - vaddr;
		}

		paddr = mn_addr_trans(vaddr);
		if (paddr) {
			flush_L1_cache_range(vaddr, vaddr + size);
			flush_L2_dcache_range(paddr, paddr + size);
		}
	}
#endif /* !(CONFIG_L1_OFF && CONFIG_L2_OFF) */

	return;
}
#else /* CONFIG_UNIPHIER */

void  flush_cache (unsigned long dummy1, unsigned long dummy2)
{
#ifdef CONFIG_OMAP2420
	void arm1136_cache_flush(void);

	arm1136_cache_flush();
#endif
	return;
}
#endif /* CONFIG_UNIPHIER */
