/*
 * Copyright (C) 2010 Panasonic Corporation
 * All Rights Reserved.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/mach-types.h>
#include <config.h>
#include <netdev.h>

/*
 * Routine: board_init
 * Description: Early hardware init.
 */
int board_init(void)
{
	DECLARE_GLOBAL_DATA_PTR;

	/* board id for Linux */
	gd->bd->bi_arch_number = MACH_TYPE_MN2WS0220_REF;
	/* boot param addr */
	gd->bd->bi_boot_params = (LINUX_BOOT_PARAM_ADDR);

	gd->flags = 0;

	return 0;
}

int boad_eth_init(bd_t *bis)
{
#if defined(CONFIG_SMC911X)
	return smc911x_initialize(0, CONFIG_SMC911X_BASE);
#else
	return 1;
#endif
}

