#ifndef __MN2WS_MMC__H__
#define __MN2WS_MMC__H__

#define	SYSTEM_MIO_BASEADDR	0x59810000
#define	SDIP_BASEADDR		0x5a400000

#define	SYS_MIO_CLKCTRL0	(SYSTEM_MIO_BASEADDR  + 0x00000020)
#define	SYS_MIO_MODECTRL0	(SYSTEM_MIO_BASEADDR  + 0x00000030)
#define	SYS_MIO_EMMC0_HWRST	(SYSTEM_MIO_BASEADDR  + 0x00000080)
#define	SYS_MIO_RSTCTRL0	(SYSTEM_MIO_BASEADDR  + 0x00000110)

#define DMAC_BASEADDR	0x5a000000
#define DMAC_CH		4

#define DMAC_CDMIO_STRT0		(DMAC_BASEADDR + 0x0000)

#define DMAC_CDMIO_CH4STAT			(DMAC_BASEADDR + 0x0110 + 0x40 * DMAC_CH)
#define DMAC_CDMIO_CH4IR			(DMAC_BASEADDR + 0x0114 + 0x40 * DMAC_CH)
#define DMAC_CDMIO_CH4IE			(DMAC_BASEADDR + 0x0118 + 0x40 * DMAC_CH)
#define DMAC_CDMIO_CH4ID			(DMAC_BASEADDR + 0x011C + 0x40 * DMAC_CH)
#define DMAC_CDMIO_CH4SRCAMODE		(DMAC_BASEADDR + 0x0120 + 0x40 * DMAC_CH)
#define DMAC_CDMIO_CH4DSTAMODE		(DMAC_BASEADDR + 0x0124 + 0x40 * DMAC_CH)
#define DMAC_CDMIO_CH4SRCSTRTADRS	(DMAC_BASEADDR + 0x0128 + 0x40 * DMAC_CH)
#define DMAC_CDMIO_CH4DSTSTRTADRS	(DMAC_BASEADDR + 0x012C + 0x40 * DMAC_CH)
#define DMAC_CDMIO_CH4SIZE			(DMAC_BASEADDR + 0x0130 + 0x40 * DMAC_CH)

#define DMAC_CDMIO_RB4BGNADRS		(DMAC_BASEADDR + 0x0800 + 0x40 * DMAC_CH)
#define DMAC_CDMIO_RB4ENDADRS		(DMAC_BASEADDR + 0x0804 + 0x40 * DMAC_CH)
#define DMAC_CDMIO_RB4RDPTR			(DMAC_BASEADDR + 0x0820 + 0x40 * DMAC_CH)
#define DMAC_CDMIO_RB4WRPTR			(DMAC_BASEADDR + 0x0828 + 0x40 * DMAC_CH)

#define DMAC_CDMIO_STRT0_REQ		(0x00000001 << DMAC_CH)
#define DMAC_CDMIO_STRT0_STOP		 0x80000000

#define DMAC_CDMIO_CHAMODE_TYPE0	 0x00000000
#define DMAC_CDMIO_CHAMODE_TYPE1	 0x00000004
#define DMAC_CDMIO_CHAMODE_TYPE2	 0x00000008
#define DMAC_CDMIO_CHAMODE_AUPDT0	 0x00000000
#define DMAC_CDMIO_CHAMODE_AUPDT1	 0x00000010
#define DMAC_CDMIO_CHAMODE_AUPDT2	 0x00000020
#define DMAC_CDMIO_CHAMODE_SRCRSSEL	 0x0000FF00
#define DMAC_CDMIO_CHAMODE_DSTRSSEL	 0x0000FF00
#define DMAC_CDMIO_CHAMODE_ENDIAN0	 0x00000000
#define DMAC_CDMIO_CHAMODE_ENDIAN1	 0x00010000
#define DMAC_CDMIO_CHAMODE_ENDIAN2	 0x00020000
#define DMAC_CDMIO_CHAMODE_ENDIAN3	 0x00030000

#define DMAC_CDMIO_CH_ALLCLR		 0x00000000
#define DMAC_CDMIO_CH_ER_MASK		 0xffff0000
#define DMAC_CDMIO_CH_ER0			 0x00010000
#define DMAC_CDMIO_CH_ER1			 0x00020000
#define DMAC_CDMIO_CH_ER2			 0x00040000
#define DMAC_CDMIO_CH_ER3			 0x00080000
#define DMAC_CDMIO_CH_ER4			 0x00100000
#define DMAC_CDMIO_CH_ER5			 0x00200000
#define DMAC_CDMIO_CH_CH_MASK		 0x0000ffff
#define DMAC_CDMIO_CH_CH0			 0x00000001
#define DMAC_CDMIO_CH_CH1			 0x00000002
#define DMAC_CDMIO_CH_CH4			 0x00000010
#define DMAC_CDMIO_CH_CH5			 0x00000020
#define DMAC_CDMIO_CH_CH13			 0x00002000
#define DMAC_CDMIO_CH_CH14			 0x00004000


#ifndef __ASSEMBLY__

/*
 * Structure for struct SoC access.
 * Names starting with '_' are fillers.
 */
typedef struct mn2ws_mmc {
	/*	reg	Offset */
	u32	sd_cmd;				/* 0x00000000 */
	u32	sd_portsel;			/* 0x00000004 */
	u32	sd_arg0;			/* 0x00000008 */
	u32	sd_arg1;			/* 0x0000000c */
	u32	sd_stop;			/* 0x00000010 */
	u32	sd_seccnt;			/* 0x00000014 */
	u32	sd_rsp0;			/* 0x00000018 */
	u32	sd_rsp1;			/* 0x0000001c */
	u32	sd_rsp2;			/* 0x00000020 */
	u32	sd_rsp3;			/* 0x00000024 */
	u32	sd_rsp4;			/* 0x00000028 */
	u32	sd_rsp5;			/* 0x0000002c */
	u32	sd_rsp6;			/* 0x00000030 */
	u32	sd_rsp7;			/* 0x00000034 */
	u32	sd_info1;			/* 0x00000038 */
	u32	sd_info2;			/* 0x0000003c */
	u32	sd_info1_mask;		/* 0x00000040 */
	u32	sd_info2_mask;		/* 0x00000044 */
	u32	sd_clk_ctrl;		/* 0x00000048 */
	u32	sd_size;			/* 0x0000004c */
	u32	sd_option;			/* 0x00000050 */
	u32	reserved1;
	u32	sd_err_sts1;		/* 0x00000058 */
	u32	sd_err_sts2;		/* 0x0000005c */
	u32	sd_buf;				/* 0x00000060 */
	u32	reserved2;
	u32	sdio_mode;			/* 0x00000068 */
	u32	sdio_info1;			/* 0x0000006c */
	u32	sdio_info1_mask;	/* 0x00000070 */
	u32	reserved3[79];
	u32	cc_ext_mode;		/* 0x000001b0 */
	u32	reserved4[3];
	u32	soft_rst;			/* 0x000001c0 */
	u32	version;			/* 0x000001c4 */
	u32	host_mode;			/* 0x000001c8 */
	u32	sdif_mode;			/* 0x000001cc */
	u32	reserved5[5];
	u32	status;				/* 0x000001e4 */
	u32	ext_sdio;			/* 0x000001e8 */
	u32	ext_wp;				/* 0x000001ec */
	u32	ext_cd;				/* 0x000001f0 */
	u32	ext_cd_dat3;		/* 0x000001f4 */
	u32	ext_cd_mask;		/* 0x000001f8 */
	u32	ext_cd_dat3_mask;	/* 0x000001fc */
} mn2ws_mmc_t;

#endif /* __ASSEMBLY__ */

/* SD_CMD define */
#define SD_CMD_MODE_NORMAL		0x0000
#define SD_CMD_MODE_SECURITY	0x4000

#define SD_CMD_BK_SINGLE		0x0000
#define SD_CMD_BK_MULT			0x2000

#define SD_CMD_RW_WRITE			0x0000
#define SD_CMD_RW_READ			0x1000

#define SD_CMD_DAT_NODATA		0x0000
#define SD_CMD_DAT_ADTC			0x0800

#define SD_CMD_RESP_NORMAL		0x0000
#define SD_CMD_RESP_NORESP		0x0300
#define SD_CMD_RESP_R1			0x0400	// R1,  R5,  R6,  R7
#define SD_CMD_RESP_R1B			0x0500	// R1b, R5b
#define SD_CMD_RESP_R2			0x0600	// R2
#define SD_CMD_RESP_R3			0x0700	// R3,  R4

#define SD_CMD_SW_ADTC_R1		SD_CMD_MODE_SECURITY | SD_CMD_BK_SINGLE | SD_CMD_RW_WRITE | SD_CMD_DAT_ADTC   | SD_CMD_RESP_R1
#define SD_CMD_SR_ADTC_R1		SD_CMD_MODE_SECURITY | SD_CMD_BK_SINGLE | SD_CMD_RW_READ  | SD_CMD_DAT_ADTC   | SD_CMD_RESP_R1
#define SD_CMD_NODATA_NORESP	SD_CMD_MODE_SECURITY | SD_CMD_BK_SINGLE | SD_CMD_RW_WRITE | SD_CMD_DAT_NODATA | SD_CMD_RESP_NORESP
#define SD_CMD_NODATA_R1		SD_CMD_MODE_SECURITY | SD_CMD_BK_SINGLE | SD_CMD_RW_WRITE | SD_CMD_DAT_NODATA | SD_CMD_RESP_R1
#define SD_CMD_NODATA_R1B		SD_CMD_MODE_SECURITY | SD_CMD_BK_SINGLE | SD_CMD_RW_WRITE | SD_CMD_DAT_NODATA | SD_CMD_RESP_R1B
#define SD_CMD_NODATA_R3		SD_CMD_MODE_SECURITY | SD_CMD_BK_SINGLE | SD_CMD_RW_WRITE | SD_CMD_DAT_NODATA | SD_CMD_RESP_R3

/* SD_INFO1 define */
#define SD_INFO1_INFO_RWA_CMP	0x0004
#define SD_INFO1_INFO_CMD_CMP	0x0001

/* SD_INFO2 define */
#define SD_INFO2_ERROR_ILA		0x8000
#define SD_INFO2_ERROR_RESP_TO	0x0040
#define SD_INFO2_ERROR_ILRA		0x0020
#define SD_INFO2_ERROR_ILWA		0x0010
#define SD_INFO2_ERROR_TO		0x0008
#define SD_INFO2_ERROR_ENDBIT	0x0004
#define SD_INFO2_ERROR_CRC		0x0002
#define SD_INFO2_ERROR_CMD		0x0001
#define SD_INFO2_ERROR_ALL	(SD_INFO2_ERROR_ILA     | \
				 SD_INFO2_ERROR_RESP_TO | \
				 SD_INFO2_ERROR_ILRA    | \
				 SD_INFO2_ERROR_ILWA    | \
				 SD_INFO2_ERROR_TO      | \
				 SD_INFO2_ERROR_ENDBIT  | \
				 SD_INFO2_ERROR_CRC     | \
				 SD_INFO2_ERROR_CMD)

#define SD_INFO2_INFO_CBSY	0x4000
#define SD_INFO2_INFO_BWE	0x0200
#define SD_INFO2_INFO_BRE	0x0100

#endif /* __MN2WS_MMC__H__ */
