/* nand-mn2ws-unit.h: unit-specific mtd file
 *
 * Copyright (C) 2006-2008 Panasonic Corporation
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 */

#ifndef _ASM_UNIT_NAND_MN2WS_UNIT_H
#define _ASM_UNIT_NAND_MN2WS_UNIT_H


//#
//# Architecture dependent settings
//#

//Memory map of nand-gpbc
#define NAND_GPBC_UNIT_MEM_BASE		CONFIG_SYS_NAND_BASE
#define NAND_GPBC_UNIT_MEM_SIZE		CONFIG_SYS_NAND_IOREMAP_SIZE
#define NAND_GPBC_UNIT_REG_BASE		CONFIG_SYS_NAND_REG_BASE
#define NAND_GPBC_UNIT_REG_SIZE		CONFIG_SYS_NAND_REG_IOREMAP_BASE

#ifdef	CONFIG_MTD_NAND_MN2WS_BB
//the number of boot block {chip0, chip1, }
#define NAND_GPBC_UNIT_BTBLOCKS		{1, 0, 0, 0, 0, 0, 0, 0}

//the number of maintain block {chip0, chip1, }
#if defined(CONFIG_MTD_NAND_MAP_V1)
#define NAND_GPBC_UNIT_MTBLOCKS		{128, 128, 0, 0, 0, 0, 0, 0}
#elif defined(CONFIG_MTD_NAND_MAP_V2)
#ifdef PANA_SAMPLE_BOARD
#define NAND_GPBC_UNIT_MTBLOCKS		{400, 0 , 0, 0, 0, 0, 0, 0}
#else
#define NAND_GPBC_UNIT_MTBLOCKS		{128, 0 , 0, 0, 0, 0, 0, 0}
#endif
#else
# error Unknown NAND MAP version !!
#endif
#endif	//CONFIG_MTD_NAND_MN2WS_BB

// If maximum number of the corrected bit of each sector is larger than
// this definition, -EUCLEAN is notified to upper layer.
// If uncorrectable error occurs, -EBADMSG is notified to upper layer.
#define NAND_GPBC_CORRECTION_THRESHOLD	1


//#
//# Nand chip dependent settings
//#

// Enabled banks
#ifdef CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND
#define NAND_GPBC_FLASH_BANKS		1
#else
#ifdef PANA_SAMPLE_BOARD
#define NAND_GPBC_FLASH_BANKS		2
#else
#define NAND_GPBC_FLASH_BANKS		1
#endif
#endif	//CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND

// Manufacturer ID
#ifdef PANA_SAMPLE_BOARD
#define NAND_GPBC_UNIT_MID		0x98
#else
#define NAND_GPBC_UNIT_MID		0x01 /* samsung */
#endif

// Device ID
#ifdef PANA_SAMPLE_BOARD
#define NAND_GPBC_UNIT_DID		0xd3
#else
#define NAND_GPBC_UNIT_DID		0xdc /* 2kB, 128MiB */
#endif

// offset of ECC in oob area
#define NAND_GPBC_UNIT_OOB_ECCPOS	{50,51,52,53,54,55,56,57,58,59,60,61,62,63}

// user part in oob area {offset, size}
#ifdef CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND

	#ifdef CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG
		#define NAND_GPBC_UNIT_OOB_OOBFREE	{{4,4},{64, 64}}
	#else /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */
		#define NAND_GPBC_UNIT_OOB_OOBFREE	{{2,6},{64, 64}}
	#endif /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */

#else	//CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND

#ifdef CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG
#ifdef PANA_SAMPLE_BOARD
#define NAND_GPBC_UNIT_OOB_OOBFREE	{{4,4},{64, 64}}
#else
#define NAND_GPBC_UNIT_OOB_OOBFREE	{{4,4},{36,28}}
#endif
#else /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */
#define NAND_GPBC_UNIT_OOB_OOBFREE	{{2,6},{36, 28}}
#endif /* CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG */

#endif	//CONFIG_MTD_NAND_MN2WS_USE_8GBIT_NAND

// pulse settings
#define NAND_GPBC_UNIT_NCDWR		(((CONFIG_SYS_NAND_TWHR2) << 8) | (CONFIG_SYS_NAND_WE2RE))
#define NAND_GPBC_UNIT_NCAAD		(((CONFIG_SYS_NAND_TCWAW) << 8) | (CONFIG_SYS_NAND_ADDR2DATA))
#define NAND_GPBC_UNIT_NRW		CONFIG_SYS_NAND_RE2WE
#define NAND_GPBC_UNIT_NRDCP		CONFIG_SYS_NAND_RDCP
#define NAND_GPBC_UNIT_NRWLP		CONFIG_SYS_NAND_RWLP
#define NAND_GPBC_UNIT_NRWHP		CONFIG_SYS_NAND_RWHP
#define NAND_GPBC_UNIT_NCES		CONFIG_SYS_NAND_CES
#define NAND_GPBC_UNIT_NRR		CONFIG_SYS_NAND_RE2RE

#ifdef MTD_NAND_MN2WS_GPBC_ECC_BUG
#define NAND_GPBC_UNIT_CA_BYTES		2	//Column Address Bytes
#define NAND_GPBC_UNIT_PA_BYTES		3	//Page Address Bytes
#endif


//#
//# Partition settings
//#

/* NOTICE: Partition setting has been moved to unit-init.c */

#endif	//_ASM_UNIT_NAND_MN2WS_UNIT_H
