/*
 * Configuation settings for MN2WS0220_ref
 *
 * Copyright (C) 2010 Panasonic Corporation
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef __MN2WS0220_ref_H
#define __MN2WS0220_ref_H

#include <asm/arch/config.h>
#include <asm/arch/memory_layout.h>
#include <knl_autoconf.h>

/*-----------------------------------------------------------------------
 * CPU Type		(no use this define)
 *----------------------------------------------------------------------*/
#define CONFIG_UNIPHIER
/*-----------------------------------------------------------------------
 * Board Type
 *----------------------------------------------------------------------*/
#define CONFIG_MN2WS0220_ref
/*-----------------------------------------------------------------------
 * MMU and Cache Setting
 *----------------------------------------------------------------------*/
#define CONFIG_UNIPHIER_MMU_ENABLE
//#define CONFIG_L1_OFF

#if !defined(CONFIG_UNIPHIER_MMU_ENABLE) && !defined(CONFIG_L1_OFF)
#error "If you want to use D-Cache, you have to enable MMU."
#endif


/*-----------------------------------------------------------------------
 * Memory Size & Mapping
 *----------------------------------------------------------------------*/
/* Physical start address of boot monitor code */
#define CONFIG_SYS_MONITOR_BASE		BOOTLOADER_TOP_ADDRESS
#define CONFIG_SYS_RELOC_MONITOR_BASE	BOOTLOADER_TOP_ADDRESS
//#define CONFIG_SYS_MONITOR_SIZE		BOOTROM_SIZE
#define CONFIG_SYS_MONITOR_LEN		(128 * 1024)
//#define CONFIG_SYS_MALLOC_LEN		(384 * 1024)
#define CONFIG_SYS_MALLOC_LEN		(1024 * 1024)

/*Start address of memory area */
#define CONFIG_SYS_INIT_RAM_ADDR	BOOTLOADER_DATA_TOP_ADDRESS

/* Start Address of Environment Data */
#define CONFIG_SYS_ENV_DATA_OFFSET	(4 * 1024)
#define CONFIG_SYS_ENV_DATA_ADDR	(BOOTLOADER_DATA_TOP_ADDRESS + CONFIG_SYS_ENV_DATA_OFFSET)

/* Physical start address of SDRAM */
#define CONFIG_SYS_SDRAM_BASE		0x80000000
#define CONFIG_SYS_SDRAM_SIZE		0x20000000
/* memtest works on */
#define CONFIG_SYS_MEMTEST_START	CONFIG_SYS_SDRAM_BASE
#define CONFIG_SYS_MEMTEST_END		(CONFIG_SYS_SDRAM_BASE + 0x01000000)

/* start address of UNCACHE AREA */
#ifdef CONFIG_MN2WS0220_ES1
#define CONFIG_SYS_UNCACHE_BASE		0xc0000000
#else
#define CONFIG_SYS_UNCACHE_BASE		0xe0000000
#endif

/* start of L2 cache registers */
#define CONFIG_SYS_L2C_BASE		0x50000000	/* P.A. */


/*-----------------------------------------------------------------------
 * first step setting
 *----------------------------------------------------------------------*/
#define LINUX_BOOT_PARAM_ADDR		(CONFIG_KERNEL_RAM_BASE_ADDRESS+0x3000)
#ifndef CONFIG_UNIPHIER_L2CACHE_ENABLE
#define CONFIG_L2_OFF			1
#endif
//#define CONFIG_SKIP_LOWLEVEL_INIT	1
#define CONFIG_SKIP_RELOCATE_UBOOT	1
#define CONFIG_CMDLINE_TAG		1

#define CONFIG_SILENT_CONSOLE	1
#define CONFIG_DISABLE_CONSOLE	1
/*-----------------------------------------------------------------------
 * Display CPU and Board information
 *----------------------------------------------------------------------*/
//#define CONFIG_DISPLAY_CPUINFO		1
//#define CONFIG_DISPLAY_BOARDINFO	1

/*-----------------------------------------------------------------------
 * UNIPHIER Serial Configuration
 *----------------------------------------------------------------------*/
#define CONFIG_UNIPHIER_SERIAL
#define CONFIG_UNIPHIER_SERIAL_HIGH_SPEED
#ifdef PANA_SAMPLE_BOARD
#define CONFIG_UNIPHIER_SERIAL_BASE	0x54006800
#else
#define CONFIG_UNIPHIER_SERIAL_BASE	0x54006900 //ohnuma tmp. uart1
#endif

/*-----------------------------------------------------------------------
 * serial console configuration
 *----------------------------------------------------------------------*/
#define CONFIG_BAUDRATE			115200
#define CONFIG_NOREPEAT_COMMAND

/*-----------------------------------------------------------------------
 * Network configuration
 *----------------------------------------------------------------------*/
#define CONFIG_NET_MULTI
#define CONFIG_TFTP_BLOCKSIZE		1024
#define CONFIG_SYS_MAC_EEPROM		0	/* 1:MAC address recorded in EEPROM */

/*-----------------------------------------------------------------------
 * UNIPHIER Ethernet Configuration
 *----------------------------------------------------------------------*/
#if defined PANA_SAMPLE_BOARD /* tmp. HEC HDMI SW loopback bug.  */
#define CONFIG_UNIPHIER_AVEV3
#define CONFIG_UNIPHIER_ETHERNET
#endif
#define CONFIG_UNIPHIER_ETHERNET_BASE	0x57000000
#define CONFIG_UNIPHIER_ETHERNET_NC_OFF	0x00000000

//#define CONFIG_SMC911X
//#define CONFIG_SMC911X_32_BIT
//#define CONFIG_SMC911X_BASE		0x90000000

/*-----------------------------------------------------------------------
 * FLASH related
 *----------------------------------------------------------------------*/
#define CONFIG_MTD_DEVICE
#define CONFIG_SYS_NO_FLASH
//#define CONFIG_SYS_FLASH_BASE
//#define CONFIG_SYS_FLASH_SIZE

/*-----------------------------------------------------------------------
 * NAND-FLASH related
 *----------------------------------------------------------------------*/
#define CONFIG_SYS_MAX_NAND_DEVICE		1
#define CONFIG_NAND_GPBC
#define CONFIG_SYS_NAND_BASE			0xf8000000
#define CONFIG_SYS_NAND_IOREMAP_SIZE		0x00000020
#define CONFIG_SYS_NAND_REG_BASE		0xf8100000
#define CONFIG_SYS_NAND_REG_IOREMAP_BASE	0x00001000
#define CONFIG_MTD_NAND_MN2WS_GPBC_DMA
#ifdef CONFIG_MTD_NAND_MN2WS_GPBC_DMA
#define CONFIG_MTD_NAND_MN2WS_GPBC_CDMA_READ
#endif
#ifdef  CONFIG_MTD_NAND_MN2WS_GPBC_CDMA_READ
#define CONFIG_NAND_CMD_DESC_ADDR		0x9b800000 /* uncache */
#endif
/* pulse settings */
#define CONFIG_SYS_NAND_CES			0x3
#ifdef PANA_SAMPLE_BOARD
#define CONFIG_SYS_NAND_RWLP			0x4
#else
#define CONFIG_SYS_NAND_RWLP			0x7
#endif
#define CONFIG_SYS_NAND_RWHP			0x4
#define CONFIG_SYS_NAND_TWHR2			0x14
#define CONFIG_SYS_NAND_WE2RE			0x26
#if defined(CONFIG_USE_BOARD_OPTION_C)
#define CONFIG_SYS_NAND_RE2WE			0xE
#else
#define CONFIG_SYS_NAND_RE2WE			0x8
#endif
#ifdef PANA_SAMPLE_BOARD
#define CONFIG_SYS_NAND_RDCP			0x8
#else
#define CONFIG_SYS_NAND_RDCP			0x9
#endif
#define CONFIG_SYS_NAND_RE2RE			0x4
#define CONFIG_SYS_NAND_TCWAW			0x14
#define CONFIG_SYS_NAND_ADDR2DATA		0x10

//#define CONFIG_SYS_NAND_SELECT_DEVICE
//#define CONFIG_JFFS2_NAND
#if 0 /* These configs synchronize with kernel config. */
#define CONFIG_MTD_NAND_MN2WS_BB
#define CONFIG_MTD_NAND_MN2WS_USE_BBT_FLAG
#endif

/*
 * For NAND booting the environment is embedded in the U-Boot image. Please take
 * look at the file board/amcc/canyonlands/u-boot-nand.lds for details.
 */
#ifdef PANA_SAMPLE_BOARD
#define CONFIG_SYS_NAND_BLOCK_SIZE	0x40000
#define CONFIG_SYS_NAND_PAGE_SIZE	0x01000
#else
#define CONFIG_SYS_NAND_BLOCK_SIZE	0x20000
#define CONFIG_SYS_NAND_PAGE_SIZE	0x800
#endif
#if defined(CONFIG_MTD_NAND_MAP_V1)
#ifdef PANA_SAMPLE_BOARD
#define CONFIG_SYS_NAND_U_BOOT_OFFS	(CONFIG_SYS_NAND_BLOCK_SIZE * 4 )
#define CONFIG_SYS_NAND_U_BOOT_SIZE	(CONFIG_SYS_NAND_BLOCK_SIZE * 3 )
#else
#define CONFIG_SYS_NAND_U_BOOT_OFFS	(CONFIG_SYS_NAND_BLOCK_SIZE * 4 * 2)
#define CONFIG_SYS_NAND_U_BOOT_SIZE	(CONFIG_SYS_NAND_BLOCK_SIZE * 3 * 2)
#endif
#define CONFIG_ENV_OFFSET		(CONFIG_SYS_NAND_U_BOOT_OFFS + CONFIG_SYS_NAND_U_BOOT_SIZE)
#elif defined(CONFIG_MTD_NAND_MAP_V2)
#ifdef PANA_SAMPLE_BOARD
#define CONFIG_SYS_NAND_U_BOOT_OFFS	(CONFIG_SYS_NAND_BLOCK_SIZE * 6)
#define CONFIG_SYS_NAND_U_BOOT_SIZE	(CONFIG_SYS_NAND_BLOCK_SIZE * 1)
#define CONFIG_ENV_OFFSET		(CONFIG_SYS_NAND_BLOCK_SIZE * 2217)
#else
#define CONFIG_SYS_NAND_U_BOOT_OFFS	(CONFIG_SYS_NAND_BLOCK_SIZE * 170)	/**/
#define CONFIG_SYS_NAND_U_BOOT_SIZE	(CONFIG_SYS_NAND_BLOCK_SIZE * 2)
#define CONFIG_ENV_OFFSET		(CONFIG_SYS_NAND_BLOCK_SIZE * 161)	/**/
#endif
#else
# error Unknown NAND MAP version !!
#endif

#define CONFIG_ENV_IS_IN_NAND
#if defined(CONFIG_ENABLE_SECURE_EXEC)
#define CONFIG_ENV_SIZE                         ((CONFIG_SYS_NAND_BLOCK_SIZE * 1) - CONFIG_SYS_NAND_PAGE_SIZE)
#else
#define CONFIG_ENV_SIZE                         (CONFIG_SYS_NAND_BLOCK_SIZE * 1)
#endif

//#define CONFIG_ENV_IS_NOWHERE
//#define CONFIG_ENV_OFFSET_REDUND	(CONFIG_ENV_OFFSET + CONFIG_ENV_SIZE)

/* MMC related */
//#define CONFIG_GENERIC_MMC
//#define CONFIG_MN2WS0220_MMC
//#define CONFIG_MMC      /* init_part() */
//#define CONFIG_ISO_PARTITION    /* init_part() */
//#define CONFIG_MMC_TEST
//#define CONFIG_ENV_IS_IN_MMC
//#define CONFIG_SYS_MMC_ENV_DEV	0

/*-----------------------------------------------------------------------
 * Possible commands
 *----------------------------------------------------------------------*/
//#define CONFIG_CMD_BDI		/* bdinfo			*/
#define CONFIG_CMD_BOOTD	/* bootd			*/
//#define CONFIG_CMD_CONSOLE	/* coninfo			*/
#define CONFIG_CMD_ECHO		/* echo arguments		*/
//#define CONFIG_CMD_EDITENV	/* editenv			*/
//#define CONFIG_CMD_IMI		/* iminfo			*/
//#define CONFIG_CMD_ITEST	/* Integer (and string) test	*/
#define CONFIG_CMD_NAND		/* NAND flash suppport */
//#define CONFIG_CMD_LOADB	/* loadb			*/
//#define CONFIG_CMD_LOADS	/* loads			*/
#define CONFIG_CMD_MEMORY	/* md mm nm mw cp cmp crc base loop mtest */
//#define CONFIG_CMD_MISC		/* Misc functions like sleep etc*/
#define CONFIG_CMD_NET		/* bootp, tftpboot, rarpboot	*/
//#define CONFIG_CMD_NFS		/* NFS support			*/
#define CONFIG_CMD_RUN		/* run command in env variable	*/
#define CONFIG_CMD_SAVEENV	/* saveenv			*/
#define CONFIG_CMD_SOURCE	/* "source" command support	*/

//#define CONFIG_CMD_JFFS2	/* JFFS2 Support		*/
//#define CONFIG_CMD_PING
//#define CONFIG_CMD_MMC		/* MMC support			*/

/*-----------------------------------------------------------------------
 * Environment Variables
 *----------------------------------------------------------------------*/
#define CONFIG_BOOTDELAY		0
#define CONFIG_ZERO_BOOTDELAY_CHECK	/* check for keypress on bootdelay==0 */
#define CONFIG_AUTOBOOT_KEYED	1
#define CONFIG_AUTOBOOT_PROMPT	\
	"Press SPACE to abort autoboot in %d seconds\n", bootdelay
#define CONFIG_AUTOBOOT_DELAY_STR	"d"
#define CONFIG_AUTOBOOT_STOP_STR	" "

#define CONFIG_BOOTFILE		uImage

#define CONFIG_CMDLINE_EDITING		/* add command line history	*/

//#define CONFIG_BOOTCOMMAND	"bootm 0x00090000"
//#define CONFIG_BOOTCOMMAND	"tftp uImage; bootm"

/* uimagesize.sh replece CONFIG_UIMAGE_SIZE value. */
#define CONFIG_UIMAGE_SIZE "300000"
#define CONFIG_BOOTCOMMAND	"nand read 0x9a000000 0x01d80000 " CONFIG_UIMAGE_SIZE "; bootm 0x9a000000"
#define CONFIG_BOOTCOMMAND_BANKA	"nand read 0x9a000000 0x01d80000 " CONFIG_UIMAGE_SIZE "; bootm 0x9a000000"
#define CONFIG_BOOTCOMMAND_BANKB	"nand read 0x9a000000 0x08a00000 " CONFIG_UIMAGE_SIZE "; bootm 0x9a000000"
#define CONFIG_BOOTCOMMAND_VERUP	"nand read 0x9a000000 0x008a0000 600000; bootm 0x9a000000"

#include <guess_mem.h>
#ifdef PANA_SAMPLE_BOARD

#if defined(CONFIG_MTD_NAND_MAP_V1)
#define CONFIG_BOOTCOMMAND	"nand read 0x9a000000 C00000 200000 && bootm 0x9a000000"
#elif defined(CONFIG_MTD_NAND_MAP_V2)
#if defined(CONFIG_ENABLE_SECURE_EXEC)
#define CONFIG_BOOTCOMMAND	"nand read 0x9a000000 $kerneloffset 200000 && nand read 0x86b00000 $rootfsoffset $rootfssize && bootm 0x9a000000"
#else //defined(CONFIG_ENABLE_SECURE_EXEC)
#define CONFIG_BOOTCOMMAND	"nand read 0x9a000000 $kerneloffset 200000 && bootm 0x9a000000"
#endif //defined(CONFIG_ENABLE_SECURE_EXEC)
#else
# error Unknown NAND MAP version !!
#endif

#else /* PANA_SAMPLE_BOARD */

#if defined(CONFIG_MTD_NAND_MAP_V1)
#define CONFIG_BOOTARGS	"root=/dev/mtdblock9 rootfstype=squashfs rw " LINUX_CMDLINE_MEM " console=ttyS1,115200 user_debug=0x1f init=/bin/login -f root -p target=avss ip=on"
#define CONFIG_BOOTARGS_USB "console=ttyS1,115200 " LINUX_CMDLINE_MEM " user_debug=0x1f rdinit=/root/verup_usb"
#define CONFIG_BOOTARGS_PCC "console=ttyS1,115200 " LINUX_CMDLINE_MEM " user_debug=0x1f rdinit=/root/verup_pcc"
#elif defined(CONFIG_MTD_NAND_MAP_V2)
#define CONFIG_BOOTARGS	"debug root=/dev/mtdblock13 rootfstype=squashfs rw " LINUX_CMDLINE_MEM " console=ttyS1,115200 user_debug=0x1f init=/bin/tainit"
#define CONFIG_BOOTARGS_USB "console=ttyS1,115200 " LINUX_CMDLINE_MEM " user_debug=0x1f rdinit=/root/verup_usb"
#define CONFIG_BOOTARGS_PCC "console=ttyS1,115200 " LINUX_CMDLINE_MEM " user_debug=0x1f rdinit=/root/verup_pcc"
#define CONFIG_BOOTARGS_BANKA	"root=/dev/mtdblock13 rootfstype=squashfs rw lpj=6012928 " LINUX_CMDLINE_MEM " console=ttyS1,115200 user_debug=0x1f init=/bin/tainit"
#define CONFIG_BOOTARGS_BANKB	"root=/dev/mtdblock19 rootfstype=squashfs rw lpj=6012928 " LINUX_CMDLINE_MEM " console=ttyS1,115200 user_debug=0x1f init=/bin/tainit"
#endif

#endif /* PANA_SAMPLE_BOARD */

#define	CONFIG_EXTRA_ENV_SETTINGS	\
"appxip=y\0"						\
"autoboot=y\0"						


/*
 * Network Configuration
 */
//#define CONFIG_ETHADDR			00:21:83:24:00:00
#define CONFIG_LSERVERIP		156.147.69.82
#define CONFIG_SERVERIP			192.168.0.1
#define CONFIG_IPADDR			192.168.0.10
#define CONFIG_GATEWAYIP		192.168.0.1
#define CONFIG_NETMASK			255.255.255.0
/* #endif */
/*-----------------------------------------------------------------------
 * Miscellaneous Configuration Settings
 *----------------------------------------------------------------------*/
//#define CONFIG_SYS_LONGHELP		/* undef to save memory */
#define CONFIG_SYS_PROMPT		"sLDx> "
#define CONFIG_CMDLINE_EDITING		/* add command line history	*/
#define CONFIG_SYS_HUSH_PARSER		/* use "hush" command parser */
#define CONFIG_SYS_PROMPT_HUSH_PS2	"> "
#define CONFIG_SYS_CBSIZE		2048	/* Console I/O Buffer Size */
/* Print Buffer Size */
#define CONFIG_SYS_PBSIZE		(CONFIG_SYS_CBSIZE + sizeof(CONFIG_SYS_PROMPT) + 16)
#define CONFIG_SYS_MAXARGS		32	/* max number of command */
#define CONFIG_SYS_64BIT_VSPRINTF
/* Boot Argument Buffer Size */
#define CONFIG_SYS_BARGSIZE		(CONFIG_SYS_CBSIZE)
/* List of legal baudrate settings for this board */
#define CONFIG_CONS_INDEX		1
#ifdef CONFIG_UNIPHIER_SERIAL_HIGH_SPEED
#define CONFIG_SYS_BAUDRATE_TABLE	{ 115200, 230400, 460800 }
#else
#define CONFIG_SYS_BAUDRATE_TABLE	{ 9600, 19200, 38400, 57600, 115200 }
#endif	/* CONFIG_UNIPHIER_SERIAL_HIGH_SPEED */
/* Increase max gunzip size */
#define CONFIG_SYS_BOOTM_LEN	(32 << 20)
/* Boot params (bootargs) length */
#define CONFIG_SYS_BOOTPARAMS_LEN	1024
/* default load address */
#if 0 /* uImage on SDRAM */
#define CONFIG_SYS_LOAD_ADDR	0x00090000
#else /* uImage on DDR */
#define OFFSET_BASE		0x1A000000
#define CONFIG_SYS_LOAD_ADDR	(CONFIG_SYS_SDRAM_BASE + (OFFSET_BASE))
#endif

/* System Clock */
#define CONFIG_SYS_HZ			1000

/* compression format (Remove definition, If you don't need) */
#define CONFIG_LZO
//#define CONFIG_LZMA
/* compression format (select CONFIG_GZIP/CONFIG_LZO / CONFIG_LZMA) */
// for CommonPF #define CONFIG_KERNEL_COMPRESS CONFIG_LZO
#define CONFIG_KERNEL_COMPRESS CONFIG_GZIP

#endif /* __MN2WS0220_ref_H */
