#!/bin/sh

UIMAGE=../../../target/uImage
CONFFILE="./include/configs/MN2WS0220_ref.h"
if [ ! -f ${CONFFILE} ]; then
    exit 0;
fi
if [ ! -f ${UIMAGE} ]; then \
    echo "### ERROR ### ${UIMAGE} is needed for u-boot build. Make linux first."; \
    exit 1; \
fi
UIMAGE_SIZE=`wc -c ${UIMAGE} | awk '{print $1}'`
sed -i -e "s/\#define[ \t]\+CONFIG_UIMAGE_SIZE[ \t]\+\".*\"/\#define CONFIG_UIMAGE_SIZE \"`printf '%x' ${UIMAGE_SIZE}`\"/" ${CONFFILE}
