/*
  Copyright (c) 2009 Sharp Corporation, All rights reserved.
  Author                 Group          Data
  TAKAHASHI, Masafumi    PTDC4          April 3, 2009
*/

#ifndef DUMMYSYSAPI_H
#define DUMMYSYSAPI_H

#define MAX_PROC_NAME_LEN 32
#define FALSE 0
#define TRUE !0
#define S_WAITFOREVER ((diMilliSec)(-1)) /* Ԥ̵» */
#define S_NOWAIT      ((diMilliSec)(-2)) /* Ԥʤ */

typedef int int32;
typedef unsigned char uint8;
typedef unsigned int uint32;
typedef int32 boolean;
typedef boolean flag;
typedef int diMilliSec;

typedef enum {
    S_STATUS_TO_BE_ZERO,                /* ơ 0 ϻȤʤ */
    S_SUCCESS = 1,                      /*  */
    S_FAILURE,                          /*  */
    S_TIMEOUT,                          /* »֤ˤ굢 */
    S_NOT_IMPLEMENTED_YET,              /* ̤ʤΤǥ顼 */
    S_SPEC_ERROR,                       /* ϰϤ鳰ƥ顼 */
    S_RESULT_MAX
} dResult_e;                            /* ؿ */

typedef enum {
    TASK_PRI_LOWEST  = 0,
    TASK_PRI_00      = 0,
    TASK_PRI_01      = 1,
    TASK_PRI_02      = 2,
    TASK_PRI_03      = 3,
    TASK_PRI_04      = 4,
    TASK_PRI_05      = 5,
    TASK_PRI_06      = 6,
    TASK_PRI_07      = 7,
    TASK_PRI_08      = 8,
    TASK_PRI_09      = 9,
    TASK_PRI_10      = 10,
    TASK_PRI_11      = 11,
    TASK_PRI_12      = 12,
    TASK_PRI_13      = 13,
    TASK_PRI_14      = 14,
    TASK_PRI_15      = 15,
    TASK_PRI_HIGHEST = 15,
    TASK_PRI_MAX
} dTaskPriority_e;                      /* ͥ */

typedef enum
{
    DBG_FATAL_ERROR = 0,                /* ̿Ū顼 */
    DBG_ERROR = 1,                      /* 顼 */
    DBG_TEST = 5,                       /* ƥ */
    DBG_LOG = 9,                        /*  */
	DBG_DEFAULT = 10,                   /* ǥե */
    DBG_INFO = 15,                      /* ǥХåѾ */
	DBG_LEVEL_MAX
} dDbgLevel_e;

typedef enum {
    SIO_LCH_NOUSE =0,
    SIO_LCH_UNREAD,
    SIO_LCH_DIRECT,
    SIO_LCH_DEBUG,
    SIO_LCH_USER,
    SIO_LCH_MAX,
    SIO_LCH_STDIO
}   eSioLogicalCh;

typedef enum {
    DBGSIO_USER,
    DBGSIO_DEBUG,
} dDbgSioOpenMode_e;

dResult_e eSioStringPut(eSioLogicalCh ch, char* s);
dResult_e eDbgPrintf(int32 iLevel, char *fmt, ...);
dResult_e eDbgChangeLevel(int32 iLevel);
dResult_e eDbgGetLevel(int32 *iLevel);
#endif
