/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/****************************************************************************/

#ifndef __FMB_MSG_H__
#define __FMB_MSG_H__

#include <linux/time.h>

#define MSG_CTL_DYNAMIC
#define MSG_DEFAULT_LVL     0x3F

#define KERN_ERR_LVL        0   /* 0x0001 */
#define LSI_ERR_LVL         1   /* 0x0002 */
#define CRIT_LVL            2   /* 0x0004 */
#define ERR_LVL             3   /* 0x0008 */
#define INTERNAL_ERR_LVL    4   /* 0x0010 */
#define RESOURCE_LVL        5   /* 0x0020 */
/*------------- default level --------------------*/
#define DRIVER_FUNC_LVL     6   /* 0x0040 */
#define INTERNAL_FUNC       7   /* 0x0080 */
#define INTERNAL_LOG        8   /* 0x0100 */
#define DEBUG_LVL           9   /* 0x0200 */
#define CMDMSG_LVL          10  /* 0x0400 */
#define SYSMSG_LVL          11  /* 0x0800 */
#define VIDEOMSG_LVL        12  /* 0x1000 */
#define AUDIOMSG_LVL        13  /* 0x2000 */
#define DMA0MSG_LVL         14  /* 0x4000 */
#define DMA1MSG_LVL         15  /* 0x8000 */

#ifdef  MSG_CTL_DYNAMIC
#ifndef MSG_DESCRIPTION
#define MSG_DESCRIPTION "\n"                                                    \
            "\tSelect the output message level(default: msg_lvl=0x3F)\n"        \
            "\tShow Kernel error message                           0x0001\n"    \
            "\tShow MB86H57 LSI error message                      0x0002\n"   \
            "\tNone                                                0x0004\n"    \
            "\tNone                                                0x0008\n"    \
            "\tShow Driver internal error messsage                 0x0010\n"    \
            "\tShow Hard/OS resource that driver uses massage      0x0020\n"    \
            "\tShow Start/end message of system call function      0x0040\n"    \
            "\tShow Start/end message of driver external function  0x0080\n"    \
            "\tShow Start/end message of driver internal function  0x0100\n"    \
            "\tShow Debug message                                  0x0200\n"    \
            "\tShow Interrupt from command message                 0x0400\n"    \
            "\tShow Interrupt from system message                  0x0800\n"    \
            "\tShow Interrupt from video message                   0x1000\n"    \
            "\tShow Interrupt from audio message                   0x2000\n"    \
            "\tShow Interrupt from dma0 message                    0x4000\n"    \
            "\tShow Interrupt from dma1 message                    0x8000\n"    \

#endif  /* MSG_DESCRIPTION */
#define PREPARE_DEBUG()                         \
        long msg_lvl = MSG_DEFAULT_LVL;     \
        module_param(msg_lvl, long, S_IRUGO);       \
        MODULE_PARM_DESC(msg_lvl, MSG_DESCRIPTION);
#define PREPARE_DEBUG_FOR_FUNC()                \
        extern long msg_lvl;
#else   /* MSG_CTL_DYNAMIC */
#define PREPARE_DEBUG   do
            {
            } while(0)
#define PREPARE_DEBUG_FOR_FUNC  do
            {
            } while(0)
#endif  /* MSG_CTL_DYNAMIC */

#ifdef  MSG_CTL_DYNAMIC
#else   /* MSG_CTL_DYNAMIC */
#define MSG_CTL_PREFIX  do
            {
            } while(0)
#endif  /* MSG_CTL_DYNAMIC */

/*
        sprintf( g_timechar, "????.??????" );                                               \
*/

/* set variable minor */
#define FMB_MSG_MODE_MINOR_OFF  -1 //< none minor
#define FMB_MSG_MODE_ALL        -2 //< msg_lvl all


#define __MESSAGE( fi, l, f, lvl, m, fmt,arg... )   do                                      \
{                                                                                           \
    struct  timeval     g_tv            = {0};                                              \
    char                g_timechar[16]  = {0};                                              \
    char    level = lvl;                                                                    \
                                                                                            \
    if (((msg_lvl >> lvl) & 0x01) || m == FMB_MSG_MODE_ALL ) {                              \
        do_gettimeofday( &g_tv );                                                           \
        sprintf( g_timechar, "%02d.%06d", (int)(g_tv.tv_sec % 60), (int)g_tv.tv_usec );     \
                                                                                            \
        if (m < 0) {                                                                        \
            if ( m == FMB_MSG_MODE_ALL )                                                    \
            {                                                                               \
            switch (level)                                                                  \
            {                                                                               \
                case KERN_ERR_LVL:                                                          \
                    printk( FMB_DRIVER_NAME"(%s) : <0> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case LSI_ERR_LVL:                                                           \
                    printk( FMB_DRIVER_NAME"(%s) : <1> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case CRIT_LVL:                                                              \
                    printk( FMB_DRIVER_NAME"(%s) : <2> %s(%i) %s: " fmt "\n",       \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case ERR_LVL:                                                               \
                    printk( FMB_DRIVER_NAME"(%s) : <3> %s(%i) %s: " fmt "\n",       \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case INTERNAL_ERR_LVL:                                                      \
                    printk( FMB_DRIVER_NAME"(%s) : <4> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case RESOURCE_LVL:                                                          \
                    printk( FMB_DRIVER_NAME"(%s) : <5> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case DRIVER_FUNC_LVL:                                                       \
                    printk( FMB_DRIVER_NAME"(%s) : <6> %s(%i) %s: " fmt "\n",       \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case INTERNAL_FUNC:                                                         \
                    printk( FMB_DRIVER_NAME"(%s) : <7> %s(%i) %s: " fmt "\n",       \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case INTERNAL_LOG:                                                          \
                    printk( FMB_DRIVER_NAME"(%s) : <8> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case DEBUG_LVL:                                                             \
                    printk( FMB_DRIVER_NAME"(%s) : <9> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case CMDMSG_LVL:                                                            \
                    printk( FMB_DRIVER_NAME"(%s) : <10> %s(%i) %s: " fmt "\n",  \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case SYSMSG_LVL:                                                            \
                    printk( FMB_DRIVER_NAME"(%s) : <11> %s(%i) %s: " fmt "\n",  \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case VIDEOMSG_LVL:                                                          \
                    printk( FMB_DRIVER_NAME"(%s) : <12> %s(%i) %s: " fmt "\n",  \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case AUDIOMSG_LVL:                                                          \
                    printk( FMB_DRIVER_NAME"(%s) : <13> %s(%i) %s: " fmt "\n",  \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case DMA0MSG_LVL:                                                           \
                    printk( FMB_DRIVER_NAME"(%s) : <14> %s(%i) %s: " fmt "\n",  \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case DMA1MSG_LVL:                                                           \
                    printk( FMB_DRIVER_NAME"(%s) : <15> %s(%i) %s: " fmt "\n",  \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                default:                                                                    \
                    break;                                                                  \
            }                                                                               \
            }                                                                               \
            else                                                                            \
            {                                                                               \
            switch (level)                                                                  \
            {                                                                               \
                case KERN_ERR_LVL:                                                          \
                    printk( KERN_EMERG FMB_DRIVER_NAME"(%s) : <0> %s(%i) %s: " fmt "\n",    \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case LSI_ERR_LVL:                                                           \
                    printk( KERN_ALERT FMB_DRIVER_NAME"(%s) : <1> %s(%i) %s: " fmt "\n",    \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case CRIT_LVL:                                                              \
                    printk( KERN_CRIT FMB_DRIVER_NAME"(%s) : <2> %s(%i) %s: " fmt "\n",     \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case ERR_LVL:                                                               \
                    printk( KERN_ERR FMB_DRIVER_NAME"(%s) : <3> %s(%i) %s: " fmt "\n",      \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case INTERNAL_ERR_LVL:                                                      \
                    printk( KERN_WARNING FMB_DRIVER_NAME"(%s) : <4> %s(%i) %s: " fmt "\n",  \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case RESOURCE_LVL:                                                          \
                    printk( KERN_NOTICE FMB_DRIVER_NAME"(%s) : <5> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case DRIVER_FUNC_LVL:                                                       \
                    printk( KERN_INFO FMB_DRIVER_NAME"(%s) : <6> %s(%i) %s: " fmt "\n",     \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case INTERNAL_FUNC:                                                         \
                    printk( KERN_INFO FMB_DRIVER_NAME"(%s) : <7> %s(%i) %s: " fmt "\n",     \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case INTERNAL_LOG:                                                          \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"(%s) : <8> %s(%i) %s: " fmt "\n",    \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case DEBUG_LVL:                                                             \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"(%s) : <9> %s(%i) %s: " fmt "\n",    \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case CMDMSG_LVL:                                                            \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"(%s) : <10> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case SYSMSG_LVL:                                                            \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"(%s) : <11> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case VIDEOMSG_LVL:                                                          \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"(%s) : <12> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case AUDIOMSG_LVL:                                                          \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"(%s) : <13> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case DMA0MSG_LVL:                                                           \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"(%s) : <14> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                case DMA1MSG_LVL:                                                           \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"(%s) : <15> %s(%i) %s: " fmt "\n",   \
                            g_timechar, fi, l, f, ##arg );                                  \
                    break;                                                                  \
                default:                                                                    \
                    break;                                                                  \
            }                                                                               \
            }                                                                               \
        }                                                                                   \
        else {                                                                              \
            switch (level)                                                                  \
            {                                                                               \
                case KERN_ERR_LVL:                                                          \
                    printk( KERN_EMERG FMB_DRIVER_NAME"%d(%s) : <0> %s(%i) %s: " fmt "\n",  \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case LSI_ERR_LVL:                                                           \
                    printk( KERN_ALERT FMB_DRIVER_NAME"%d(%s) : <1> %s(%i) %s: " fmt "\n",  \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case CRIT_LVL:                                                              \
                    printk( KERN_CRIT FMB_DRIVER_NAME"%d(%s) : <2> %s(%i) %s: " fmt "\n",   \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case ERR_LVL:                                                               \
                    printk( KERN_ERR FMB_DRIVER_NAME"%d(%s) : <3> %s(%i) %s: " fmt "\n",    \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case INTERNAL_ERR_LVL:                                                      \
                    printk( KERN_WARNING FMB_DRIVER_NAME"%d(%s) : <4> %s(%i) %s: " fmt "\n",\
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case RESOURCE_LVL:                                                          \
                    printk( KERN_NOTICE FMB_DRIVER_NAME"%d(%s) : <5> %s(%i) %s: " fmt "\n", \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case DRIVER_FUNC_LVL:                                                       \
                    printk( KERN_INFO FMB_DRIVER_NAME"%d(%s) : <6> %s(%i) %s: " fmt "\n",   \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case INTERNAL_FUNC:                                                         \
                    printk( KERN_INFO FMB_DRIVER_NAME"%d(%s) : <7> %s(%i) %s: " fmt "\n",   \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case INTERNAL_LOG:                                                          \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"%d(%s) : <8> %s(%i) %s: " fmt "\n",  \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case DEBUG_LVL:                                                             \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"%d(%s) : <9> %s(%i) %s: " fmt "\n",  \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case CMDMSG_LVL:                                                            \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"%d(%s) : <10> %s(%i) %s: " fmt "\n", \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case SYSMSG_LVL:                                                            \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"%d(%s) : <11> %s(%i) %s: " fmt "\n", \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case VIDEOMSG_LVL:                                                          \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"%d(%s) : <12> %s(%i) %s: " fmt "\n", \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case AUDIOMSG_LVL:                                                          \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"%d(%s) : <13> %s(%i) %s: " fmt "\n", \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case DMA0MSG_LVL:                                                           \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"%d(%s) : <14> %s(%i) %s: " fmt "\n", \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                case DMA1MSG_LVL:                                                           \
                    printk( KERN_DEBUG FMB_DRIVER_NAME"%d(%s) : <15> %s(%i) %s: " fmt "\n", \
                            m, g_timechar, fi, l, f, ##arg );                               \
                    break;                                                                  \
                default:                                                                    \
                    break;                                                                  \
            }                                                                               \
        }                                                                                   \
    }                                                                                       \
} while(0)

#define MSG( lvl,minor,fmt, arg... ) __MESSAGE( __FILE__, __LINE__, __FUNCTION__,   \
                                                lvl, minor, fmt, ##arg )

#ifdef MSG_INFO_UPPER_OS
#define info( fmt, arg... ) printk( KERN_INFO "%s: " fmt "\n", FMB_DRIVER_NAME,  ##arg )
#endif

#endif  /* __FMB_MSG_H__ */

