#!/bin/sh

KERN_RELEASE=`uname -r`
LIBDIR="/lib/modules/$KERN_RELEASE/$MDIR"

module="h57fmb"

#
# Check root account
#
uid=`id | sed 's/uid=//' | sed 's/(.*//'`
if [ $uid != 0 ]; then
    echo "ERROR: You are not root.!!"
    exit
fi

#
# Delete restart script
#
\rm /etc/rc.d/rc6.d/S99$module

#
# Delete udev rules
#
if [ -f /etc/udev/rules.d/60-h57fmb.rules ];then
    \rm /etc/udev/rules.d/60-h57fmb.rules
fi

#
# Unload old driver module
#
grep $module /proc/modules
if [ $? = 0 ];then
    echo -n "Unloading old device driver..."
    /sbin/rmmod $module
    echo "done."
fi

#
# Uninstall new driver module
#
echo "Uninstalling device driver..."
make clean
make uninstall
echo "done."

#
# Edit /etc/rc.d/rc.local
#
echo "Please edit rc.local file..."
echo "(Delete line /etc/rc.d/rc6.d/S99h57fmb)"
echo "You can use 'vi /etc/rc.d/rc.local'"

