#ifndef AIP_H
#define AIP_H
/** @file aip.h
 *  
 * ResolverFunction
 * 
 * Copyright (c) 2007 SHARP CORPORATION
 * 
 * @author NWPF Makoto Adachi
 *
 * @change 2007/12/13 adachi@nwpf new 
 */
/* ---- header file inclusion ---- */
#include "sysapi.h"

/* ---- macro definitions ---- */
#define AIP_MSG_DATA_LEN (1)
#define IPV4_ADDR_LEN   (4)

/* ---- public type declarations ---- */
/* none */

/* ---- public variable declarations ---- */
/* none */

/* ---- public function declarations ---- */
extern dResult_e eAipInit( uint8 *pucInterFace );

extern dResult_e eAipEnableAutoIp(uint8 *pcAddr,uint32 uiAddrLen,boolean fProbe);

extern dResult_e eAipDisableAutoIp(void);

extern boolean fAipStateCheck(boolean *isReady,boolean *fAssigned,uint8 *pucAddr);
extern void vAipForceDisable(void);
extern void vAipNotifyAddress(uint8 *pucAddr,uint32 uiAddrLen);
#ifdef AIP_UNIT_TEST
extern dResult_e eAipNotifyAddress(uint8 *pucAddr,uint32 uiAddrLen);
#endif /* AIP_UNIT_TEST */
#ifdef LINKED_LNX_AIP
extern dResult_e eAipNotifyAddress(uint8 *pucAddr,uint32 uiAddrLen);
#endif /* LINKED */
#endif /* AIP_H */
